/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.nio.charset.StandardCharsets;
import net.kut3.messaging.Message;
import net.kut3.messaging.rabbitmq.Component;

public class RabbitMQMessage
implements Message,
Component {
    private final byte[] body;
    private final String bodyAsString;
    private String exchangeName = null;
    private String routingKey = null;
    private boolean isRedelivered = false;

    RabbitMQMessage(Envelope envelope, AMQP.BasicProperties props, byte[] body) {
        this.exchangeName = envelope.getExchange();
        this.routingKey = envelope.getRoutingKey();
        this.isRedelivered = envelope.isRedeliver();
        this.body = body;
        this.bodyAsString = new String(body, StandardCharsets.UTF_8);
    }

    public RabbitMQMessage(String body) {
        this.bodyAsString = body;
        this.body = body.getBytes(StandardCharsets.UTF_8);
    }

    public String property(String name) {
        switch (name) {
            case "exchangeName": {
                return this.exchangeName;
            }
            case "routingKey": {
                return this.routingKey;
            }
            case "isRedelivery": {
                return Boolean.toString(this.isRedelivered);
            }
        }
        return null;
    }

    public String bodyAsString() {
        return this.bodyAsString;
    }

    public byte[] body() {
        return this.body;
    }
}

