/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.rabbitmq.client;

import com.rabbitmq.client.ConnectionFactory;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import net.kut3.messaging.Consumer;
import net.kut3.messaging.Producer;
import net.kut3.messaging.client.ClientFactory;
import net.kut3.messaging.client.ConsumerProperties;
import net.kut3.messaging.client.ProducerProperties;
import net.kut3.messaging.rabbitmq.Component;
import net.kut3.messaging.rabbitmq.ExchangeInfo;
import net.kut3.messaging.rabbitmq.QueueInfo;
import net.kut3.messaging.rabbitmq.client.ConsumerImpl;
import net.kut3.messaging.rabbitmq.client.ProducerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQClientFactory
implements ClientFactory,
Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(RabbitMQClientFactory.class);
    private ConnectionFactory connFactory;

    public RabbitMQClientFactory(String uri) {
        ConnectionFactory tmp = new ConnectionFactory();
        try {
            tmp.setUri(uri);
        }
        catch (URISyntaxException | KeyManagementException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        this.connFactory = tmp;
    }

    public Producer newProducer(ProducerProperties props) {
        ExchangeInfo exchange = (ExchangeInfo)props.get("exchangeInfo");
        ProducerImpl newProducer = null == exchange ? new ProducerImpl(props.clientName(), this.connFactory, (String)props.get("routingKey")) : new ProducerImpl(props.clientName(), this.connFactory, exchange, (String)props.get("routingKey"));
        LOGGER.info("Initialized " + ((Object)newProducer).toString());
        return newProducer;
    }

    public Consumer newConsumer(ConsumerProperties props) {
        ExchangeInfo exchange = (ExchangeInfo)props.get("exchangeInfo");
        ConsumerImpl newConsumer = null == exchange ? new ConsumerImpl(props.clientName(), this.connFactory, (QueueInfo)props.get("queueInfo"), props.isAutoAck()) : new ConsumerImpl(props.clientName(), this.connFactory, exchange, (QueueInfo)props.get("queueInfo"), (String)props.get("routingKey"), props.isAutoAck());
        LOGGER.info("Initialized " + ((Object)newConsumer).toString());
        return newConsumer;
    }

    public void close() {
    }
}

