/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.rabbitmq.client;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import net.kut3.messaging.Message;
import net.kut3.messaging.ProcessResultCode;
import net.kut3.messaging.ProduceResult;
import net.kut3.messaging.Producer;
import net.kut3.messaging.rabbitmq.Component;
import net.kut3.messaging.rabbitmq.ExchangeInfo;
import net.kut3.messaging.rabbitmq.client.Client;
import net.kut3.messaging.rabbitmq.client.DirectExchangeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProducerImpl
extends Client
implements Producer,
Component {
    private static Logger LOGGER = LoggerFactory.getLogger(ProducerImpl.class);
    private final ExchangeInfo exchangeInfo;
    private final String routingKey;

    ProducerImpl(String name, ConnectionFactory connFactory, String routingKey) {
        this(name, connFactory, (ExchangeInfo)new DirectExchangeInfo(), routingKey);
    }

    ProducerImpl(String name, ConnectionFactory connFactory, ExchangeInfo exchangeInfo, String routingKey) {
        super(name, connFactory);
        if (null == exchangeInfo) {
            throw new IllegalArgumentException("exchangeInfo cannot be null");
        }
        if (null == routingKey) {
            throw new IllegalArgumentException("routingKey cannot be null");
        }
        super.declareExchange(exchangeInfo);
        this.exchangeInfo = exchangeInfo;
        this.routingKey = routingKey;
    }

    ProducerImpl(String name, Connection conn, ExchangeInfo exchangeInfo, String routingKey) {
        super(name, conn);
        if (null == exchangeInfo) {
            throw new IllegalArgumentException("exchangeInfo cannot be null");
        }
        if (null == routingKey) {
            throw new IllegalArgumentException("routingKey cannot be null");
        }
        super.declareExchange(exchangeInfo);
        this.exchangeInfo = exchangeInfo;
        this.routingKey = routingKey;
    }

    public String name() {
        return super.getName();
    }

    public ProduceResult produce(Message message) {
        ProduceResult ret = new ProduceResult();
        try {
            super.channel().basicPublish(this.exchangeInfo.name(), this.routingKey, null, message.body());
            return ret.code(ProcessResultCode.OK);
        }
        catch (IOException ioEx) {
            return ret.code(ProcessResultCode.ERR_GENERAL).errorDesc(ioEx.getMessage());
        }
    }

    public void close() {
        super.doClose();
    }

    public final String toString() {
        return "{\"producerName\":\"" + super.getName() + "\", \"exchange\":" + this.exchangeInfo.toString() + ", \"routingKey\":\"" + this.routingKey + "\"}";
    }
}

