/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.rabbitmq.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import net.kut3.messaging.BatchMessageProcessor;
import net.kut3.messaging.Consumer;
import net.kut3.messaging.Message;
import net.kut3.messaging.MessageProcessor;
import net.kut3.messaging.ProcessResult;
import net.kut3.messaging.rabbitmq.ExchangeInfo;
import net.kut3.messaging.rabbitmq.QueueInfo;
import net.kut3.messaging.rabbitmq.client.Client;
import net.kut3.messaging.rabbitmq.client.DirectExchangeInfo;
import net.kut3.messaging.rabbitmq.client.RabbitMQMessage;

class ConsumerImpl
extends Client
implements Consumer {
    private final boolean autoAck;
    private final ExchangeInfo exchangeInfo;
    private final QueueInfo queueInfo;
    private final String routingKey;

    ConsumerImpl(String name, ConnectionFactory connFactory, ExchangeInfo exchangeInfo, QueueInfo queueInfo, String routingKey, boolean autoAck) {
        super(name, connFactory);
        if (null == queueInfo) {
            throw new IllegalArgumentException("queueInfo cannot be null");
        }
        if (null == exchangeInfo) {
            throw new IllegalArgumentException("exchangeInfo cannot be null");
        }
        if (null == routingKey) {
            throw new IllegalArgumentException("routingKey cannot be null");
        }
        if (exchangeInfo.isDefaultExchange()) {
            if (!routingKey.equals(queueInfo.name())) {
                throw new IllegalArgumentException("If exchange is default exchange, routingKey cannot differ queue name");
            }
            super.declareQueue(queueInfo);
        } else {
            super.declareQueue(queueInfo);
            super.declareExchange(exchangeInfo);
            super.bind(exchangeInfo.name(), queueInfo.name(), routingKey);
        }
        this.queueInfo = queueInfo;
        this.exchangeInfo = exchangeInfo;
        this.routingKey = routingKey;
        this.autoAck = autoAck;
    }

    ConsumerImpl(String name, ConnectionFactory connFactory, QueueInfo queueInfo, boolean autoAck) {
        this(name, connFactory, new DirectExchangeInfo(), queueInfo, queueInfo.name(), autoAck);
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void start(final MessageProcessor processor) {
        try {
            final Channel channel = super.channel();
            channel.basicConsume(this.queueInfo.name(), this.autoAck, (com.rabbitmq.client.Consumer)new DefaultConsumer(channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    ProcessResult ret = processor.process((Message)new RabbitMQMessage(envelope, properties, body));
                    if (!ConsumerImpl.this.autoAck && ret.doAck()) {
                        channel.basicAck(envelope.getDeliveryTag(), false);
                    }
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void start(BatchMessageProcessor processor) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void close() {
        super.doClose();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\"consumerName\":\"").append(super.getName()).append("\", \"exchange\":").append(this.exchangeInfo.toString()).append("\", \"queue\":").append(this.queueInfo.toString()).append("\", \"routingKey\":\"").append(this.routingKey).append("\", \"isAutoAck\":").append(this.autoAck);
        return sb.append("}").toString();
    }
}

