/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.rabbitmq.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import net.kut3.messaging.rabbitmq.Component;
import net.kut3.messaging.rabbitmq.ExchangeInfo;
import net.kut3.messaging.rabbitmq.QueueInfo;
import org.slf4j.LoggerFactory;

abstract class Client
implements Component {
    private final String name;
    private final ConnectionFactory connFactory;
    private final boolean isConnectionOwner;
    private Connection conn;
    private Channel channel;

    Client(String name, ConnectionFactory connFactory) {
        if (null == name) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (null == connFactory) {
            throw new IllegalArgumentException("connFactory cannot be null");
        }
        this.name = name;
        this.connFactory = connFactory;
        try {
            this.conn = this.connFactory.newConnection();
            this.isConnectionOwner = true;
            this.channel = this.conn.createChannel();
        }
        catch (IOException | TimeoutException ex) {
            throw new RuntimeException(ex);
        }
    }

    Client(String name, Connection conn) {
        if (null == name) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (null == conn) {
            throw new IllegalArgumentException("conn cannot be null");
        }
        this.isConnectionOwner = false;
        this.name = name;
        this.conn = conn;
        this.connFactory = null;
    }

    public static Object tryToExtractShutdownCause(IOException ioEx) {
        ShutdownSignalException innerEx;
        if (null != ioEx.getCause() && null != (innerEx = (ShutdownSignalException)ioEx.getCause()) && !innerEx.isHardError()) {
            switch (innerEx.getReason().protocolMethodId()) {
                case 40: {
                    AMQImpl.Channel.Close channelCloseCause = (AMQImpl.Channel.Close)innerEx.getReason();
                    switch (channelCloseCause.getReplyCode()) {
                        case 406: {
                            return channelCloseCause.getReplyText();
                        }
                    }
                    break;
                }
            }
        }
        return null;
    }

    protected final String getName() {
        return this.name;
    }

    protected final Channel channel() {
        return this.channel;
    }

    protected final void declareQueue(QueueInfo queueInfo) {
        try (Channel tmpChannel = this.conn.createChannel();){
            tmpChannel.queueDeclare(queueInfo.name(), queueInfo.isDurable(), queueInfo.isTemporary(), queueInfo.isTemporary(), null);
            LoggerFactory.getLogger(this.getClass()).info("'" + this.name + "' declared queue " + queueInfo.toString() + " successfully");
        }
        catch (IOException ex) {
            Object o = Client.tryToExtractShutdownCause(ex);
            if (null != o) {
                throw new IllegalArgumentException(o.toString());
            }
            throw new RuntimeException(ex);
        }
        catch (TimeoutException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final void declareExchange(ExchangeInfo exchangeInfo) {
        if ("".equals(exchangeInfo.name())) {
            return;
        }
        try (Channel tmpChannel = this.conn.createChannel();){
            tmpChannel.exchangeDeclare(exchangeInfo.name(), exchangeInfo.bindingType(), exchangeInfo.isDurable(), false, null);
            LoggerFactory.getLogger(this.getClass()).info("'" + this.name + "' declared exchange " + exchangeInfo.toString() + " successfully");
        }
        catch (IOException ex) {
            Object o = Client.tryToExtractShutdownCause(ex);
            if (null != o) {
                throw new IllegalArgumentException(o.toString());
            }
            throw new RuntimeException(ex);
        }
        catch (TimeoutException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final void bind(String exchangeName, String queueName, String routingKey) {
        if (null == exchangeName) {
            throw new IllegalArgumentException("exchangeName cannot be null");
        }
        if ("".equals(exchangeName)) {
            throw new IllegalArgumentException("Default exchange cannot bind any queues explicitly");
        }
        if (null == queueName) {
            throw new IllegalArgumentException("queueName cannot be null");
        }
        try (Channel tmpChannel = this.conn.createChannel();){
            tmpChannel.queueBind(queueName, exchangeName, routingKey);
        }
        catch (IOException | TimeoutException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final void doClose() {
        if (null != this.channel) {
            try {
                this.channel.close();
                LoggerFactory.getLogger(this.getClass()).info("'" + this.name + "' closed current channel successfully");
            }
            catch (IOException | TimeoutException ex) {
                LoggerFactory.getLogger(this.getClass()).error("'" + this.name + "' closed channel error", (Throwable)ex);
            }
            this.channel = null;
        }
        if (this.isConnectionOwner && null != this.conn) {
            try {
                this.conn.close();
                LoggerFactory.getLogger(this.getClass()).info("'" + this.name + "' closed current connection successfully");
            }
            catch (IOException ex) {
                LoggerFactory.getLogger(this.getClass()).error("'" + this.name + "' closed connection error", (Throwable)ex);
            }
            this.conn = null;
        }
    }
}

