/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.rabbitmq.client;

import net.kut3.messaging.rabbitmq.Component;

/**
 *
 */
public class DirectProducerProperties 
        extends net.kut3.messaging.client.ProducerProperties
        implements Component {
    
    /**
     * 
     * @param name Name of this producer
     * @param queueName Name of queue used as routing key in direct binding mode
     */
    public DirectProducerProperties(String name, String queueName) {
        super(name);
        super.put(ROUTING_KEY, queueName);
    }
}
