/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.rabbitmq.client;

import net.kut3.messaging.client.ConsumerProperties;
import net.kut3.messaging.rabbitmq.Component;
import net.kut3.messaging.rabbitmq.QueueInfo;

/**
 *
 */
public class DirectConsumerProperties extends ConsumerProperties
        implements Component {

    /**
     *
     * @param name Name of the consumer
     * @param queueInfo Information of the queue to consume
     */
    public DirectConsumerProperties(String name, QueueInfo queueInfo) {
        super(name);

        if (null == queueInfo) {
            throw new IllegalArgumentException("queueInfo cannot be null");
        }

        super.put(QUEUE_INFO, queueInfo);
    }
}
