/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.rabbitmq;

/**
 *
 */
public class QueueInfo {
    
    private final String name;
    private boolean isDurable = true;
    private boolean isTemporary = false;
    
    /**
     * 
     * @param queueName Queue name
     * @throws IllegalArgumentException In case of invalid queue name found
     */
    public QueueInfo(String queueName) {
        if (null == queueName) {
            throw new IllegalArgumentException("queueName cannot be null");
        }
        
        if (queueName.trim().length() == 0) {
            throw new IllegalArgumentException("queueName cannot be empty or left blank");
        }
        
        this.name = queueName;
    }
    
    /**
     * 
     * @return Queue name
     */
    public String name() {
        return this.name;
    }
    
    /**
     * Default value is True.
     * @return True or False
     */
    public boolean isDurable() {
        return this.isDurable;
    }
    
    /**
     * 
     * @param value Queue durability
     * @return This current {@link QueueInfo} object
     */
    public QueueInfo isDurable(boolean value) {
        this.isDurable = value;
        return this;
    }
    
    /**
     * Default value is False.
     * @return True or False
     */
    public boolean isTemporary() {
        return this.isTemporary;
    }
    
    /**
     * 
     * @param value Queue is temporary or not
     * @return This current {@link QueueInfo} object
     */
    public QueueInfo isTemporary(boolean value) {
        this.isTemporary = value;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{\"name:\":\"")
                .append(this.name).append("\"");
        
         sb.append(", \"isDurable\":").append(this.isDurable)
                .append(", \"isTemporary\":").append(this.isTemporary);

        return sb.append("}").toString();
    }
    
    public static void main(String[] args) {
        System.out.println(new QueueInfo("1"));
    }
}
