/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.rabbitmq;

/**
 *
 */
public abstract class ExchangeInfo {

    private String name = "";
    private String bindingType = "direct";
    private boolean isDurable = true;

    /**
     *
     * @return Exchange name
     */
    public final String name() {
        return this.name;
    }

    /**
     * Default value is direct.
     *
     * @return Binding type
     */
    public final String bindingType() {
        return this.bindingType;
    }

    /**
     * Default value is True.
     *
     * @return True or False
     */
    public final boolean isDurable() {
        return this.isDurable;
    }

    /**
     *
     * @param value Queue durability
     * @return This current {@link ExchangeInfo} object
     */
    public final ExchangeInfo isDurable(boolean value) {
        this.isDurable = value;
        return this;
    }

    /**
     *
     * @param value Exchange name
     */
    protected final void name(String value) {
        if (null == value) {
            throw new IllegalArgumentException("name cannot be null");
        }

        this.name = value;
    }

    /**
     *
     * @param value Exchange type
     */
    protected final void bindingType(String value) {
        this.bindingType = value;
    }

    /**
     *
     * @return true of false
     */
    public final boolean isDefaultExchange() {
        return "".equals(this.name);
    }

    @Override
    public String toString() {
        return new StringBuilder("{\"name:\":\"").append(this.name)
                .append("\", \"bindingType\":\"").append(this.bindingType)
                .append("\", \"isDurable\":").append(this.isDurable)
                .append("}").toString();
    }
}
