/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.kafka.client;

import java.util.HashMap;
import net.kut3.messaging.client.ProducerProperties;
import net.kut3.messaging.kafka.Component;
import net.kut3.messaging.kafka.client.OnErrorHandler;
import org.apache.kafka.common.serialization.StringSerializer;

public class SimpleProducerProperties
extends ProducerProperties
implements Component {
    public SimpleProducerProperties(String producerName, String servers, String topic) {
        this(producerName, servers, topic, null);
    }

    public SimpleProducerProperties(String producerName, String servers, String topic, OnErrorHandler errorHandler) {
        super(producerName);
        if (null == servers || servers.trim().length() == 0) {
            throw new IllegalArgumentException("servers cannot be null or left blank");
        }
        if (null == topic || topic.trim().length() == 0) {
            throw new IllegalArgumentException("topic cannot be null or left blank");
        }
        super.put("topic", (Object)topic);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", servers);
        props.put("client.id", producerName);
        props.put("acks", "all");
        props.put("retries", 0);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        super.put("producerProps", props);
        if (null != errorHandler) {
            super.put("onError", (Object)errorHandler);
        }
    }
}

