/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.kafka.client;

import java.util.HashMap;
import java.util.Map;
import net.kut3.messaging.client.ProducerProperties;
import net.kut3.messaging.kafka.Component;
import static net.kut3.messaging.kafka.Component.*;
import static org.apache.kafka.clients.producer.ProducerConfig.*;
import org.apache.kafka.common.serialization.StringSerializer;

/**
 *
 */
public class SimpleProducerProperties extends ProducerProperties
        implements Component {

    /**
     *
     * @param producerName Name of producer
     * @param servers Bootstrap servers addresses
     * @param topic Topic to produce message to
     */
    public SimpleProducerProperties(String producerName, String servers,
            String topic) {
        this(producerName, servers, topic, null);
    }

    /**
     *
     * @param producerName Name of producer
     * @param servers Bootstrap servers addresses
     * @param topic Topic to produce message to
     * @param errorHandler Error handler
     */
    public SimpleProducerProperties(String producerName, String servers,
            String topic, OnErrorHandler errorHandler) {

        super(producerName);

        if (null == servers || servers.trim().length() == 0) {
            throw new IllegalArgumentException("servers cannot be null or left blank");
        }

        if (null == topic || topic.trim().length() == 0) {
            throw new IllegalArgumentException("topic cannot be null or left blank");
        }

        super.put(TOPIC, topic);

        Map<String, Object> props = new HashMap<>();
        props.put(BOOTSTRAP_SERVERS_CONFIG, servers);
        props.put(CLIENT_ID_CONFIG, producerName);
        props.put(ACKS_CONFIG, "all");
//        props.put(REQUEST_TIMEOUT_MS_CONFIG, 3000);
//        props.put(MAX_BLOCK_MS_CONFIG, 3000);
        props.put(RETRIES_CONFIG, 0);
        props.put(KEY_SERIALIZER_CLASS_CONFIG, StringSerializer.class);
        props.put(VALUE_SERIALIZER_CLASS_CONFIG, StringSerializer.class);

        super.put(PRODUCER_PROPERTIES, props);

        if (null != errorHandler) {
            super.put(ON_ERROR, errorHandler);
        }
    }
}
