/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.kafka.client;

import java.util.Collection;
import java.util.Map;
import net.kut3.messaging.Consumer;
import net.kut3.messaging.Producer;
import net.kut3.messaging.client.ClientFactory;
import net.kut3.messaging.client.ConsumerProperties;
import net.kut3.messaging.client.ProducerProperties;
import net.kut3.messaging.kafka.Component;

/**
 *
 */
public class KafkaClientFactory implements ClientFactory, Component {

    @Override
    public Producer newProducer(ProducerProperties producerProperties) {
        return new ProducerImpl(producerProperties.clientName(),
                (Map<String, Object>) producerProperties.get(PRODUCER_PROPERTIES),
                (String) producerProperties.get(TOPIC),
                (OnErrorHandler) producerProperties.get(ON_ERROR)
        );
    }

    @Override
    public Consumer newConsumer(ConsumerProperties consumerProperties) {
        return new ConsumerImpl(consumerProperties.clientName(),
                (Map<String, Object>) consumerProperties.get(CONSUMER_PROPERTIES),
                (Collection<String>) consumerProperties.get(TOPICS));
    }

    @Override
    public void close() {
    }
}
