/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.kafka.client;

import java.util.Collection;
import java.util.HashMap;
import net.kut3.messaging.client.ConsumerProperties;
import net.kut3.messaging.kafka.Component;
import net.kut3.messaging.kafka.OffsetResetMode;
import org.apache.kafka.common.serialization.StringDeserializer;

public class SimpleConsumerProperties
extends ConsumerProperties
implements Component {
    public SimpleConsumerProperties(String producerName, String servers, String groupId, Collection<String> topics) {
        this(producerName, servers, groupId, null, topics);
    }

    public SimpleConsumerProperties(String consumerName, String servers, String groupId, OffsetResetMode offsetResetMode, Collection<String> topics) {
        super(consumerName);
        if (null == servers || servers.trim().length() == 0) {
            throw new IllegalArgumentException("servers cannot be null or left blank");
        }
        if (null == topics || topics.isEmpty()) {
            throw new IllegalArgumentException("topics cannot be null or empty");
        }
        super.put("topics", topics);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", servers);
        props.put("client.id", consumerName);
        props.put("group.id", groupId);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        if (null != offsetResetMode) {
            props.put("auto.offset.reset", offsetResetMode.asString());
        }
        super.put("consumerProperties", props);
    }
}

