/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.kafka.client;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.kut3.messaging.Message;
import net.kut3.messaging.ProcessResultCode;
import net.kut3.messaging.ProduceResult;
import net.kut3.messaging.Producer;
import net.kut3.messaging.kafka.Component;
import net.kut3.messaging.kafka.client.KafkaClientFactory;
import net.kut3.messaging.kafka.client.KafkaMessage;
import net.kut3.messaging.kafka.client.OnErrorHandler;
import net.kut3.messaging.kafka.client.SimpleProducerProperties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.LoggerFactory;

class ProducerImpl
implements Producer,
Component {
    private final String name;
    private final KafkaProducer<String, String> producer;
    private final String topic;
    private final OnErrorHandler onErrorHandler;

    ProducerImpl(String name, Map<String, Object> props, String topic, OnErrorHandler onErrorHandler) {
        this.name = name;
        this.producer = new KafkaProducer(props);
        this.topic = topic;
        this.onErrorHandler = onErrorHandler;
    }

    public String name() {
        return this.name;
    }

    public ProduceResult produce(Message message) {
        if (null == this.onErrorHandler) {
            this.producer.send(new ProducerRecord(this.topic, (Object)message.property("key"), (Object)message.bodyAsString()));
        } else {
            this.producer.send(new ProducerRecord(this.topic, (Object)message.property("key"), (Object)message.bodyAsString()), (r, e) -> {
                if (!r.hasOffset() || null != e) {
                    this.onErrorHandler.handle(this.topic, message, e);
                }
            });
        }
        return new ProduceResult().code(ProcessResultCode.OK);
    }

    public void close() {
        System.out.println("closing");
        this.producer.close();
    }

    public static void main(String[] args) throws InterruptedException {
        KafkaClientFactory clientFactory = new KafkaClientFactory();
        String producerName = "kafka-client-0.3.0-01";
        String servers = "10.1.1.99:9092,10.1.1.99:9093,10.1.1.98:9094";
        String topic = "dev.Merchant";
        ((Logger)LoggerFactory.getLogger((String)"org.apache.kafka")).setLevel(Level.ERROR);
        LoggerFactory.getLogger((String)topic).info("Begin");
        Producer producer = clientFactory.newProducer(new SimpleProducerProperties(producerName, servers, topic, (t, m, ex) -> {
            LoggerFactory.getLogger((String)t).error(m.toString());
            LoggerFactory.getLogger((String)t).error("shit", (Throwable)ex);
        }));
        for (int i = 0; i < 1000; ++i) {
            try {
                System.out.println(new Date());
                System.out.println(producer.produce((Message)new KafkaMessage("key" + i, "value" + i)));
                System.out.println(new Date());
                TimeUnit.SECONDS.sleep(2L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        producer.close();
    }
}

