/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.kafka.client;

import net.kut3.messaging.Message;
import net.kut3.messaging.kafka.Component;
import org.apache.kafka.clients.consumer.ConsumerRecord;

/**
 *
 */
public class KafkaMessage implements Message, Component {
    
    private final String key;
    private final String value;
    
    /**
     * @param key Key
     * @param value Value
     */
    public KafkaMessage(String key, String value) {
        this.key = key;
        this.value = value;
    }
    
    /**
     * 
     * @param kafkaRecord Kafka record
     */
    public KafkaMessage(ConsumerRecord<String, String> kafkaRecord) {
        this.key = kafkaRecord.key();
        this.value = kafkaRecord.value();
    }

    @Override
    public String property(String name) {
        if (KEY.equals(name)) {
            return this.key;
        }
        
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String bodyAsString() {
        return this.value;
    }

    @Override
    public byte[] body() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{\"key\":");
        
        if (null == this.key) {
            sb.append("null");
        } else {
            sb.append("\"").append(this.key).append("\"");
        }
        
        sb.append(", \"value\":");
        
        if (null == this.value) {
            sb.append("null");
        } else {
            sb.append("\"").append(this.value).append("\"");
        }
        
        return sb.append("}").toString();
    }
}
