/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.kafka;

import java.util.Properties;
import org.apache.kafka.clients.producer.ProducerRecord;

public final class KafkaProducer {
    private final ProducerBuilder builder;
    private org.apache.kafka.clients.producer.KafkaProducer<String, String> producer;

    private KafkaProducer(ProducerBuilder builder) {
        this.builder = builder;
        this.initProducer();
    }

    public void produce(String key, String value) {
        this.producer.send(new ProducerRecord(this.builder.topic, (Object)key, (Object)value));
    }

    public void close() {
        this.producer.close();
    }

    private void initProducer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.builder.servers);
        props.put("acks", "all");
        props.put("delivery.timeout.ms", (Object)31000);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.producer = new org.apache.kafka.clients.producer.KafkaProducer(props);
    }

    public static ProducerBuilder newBuilder() {
        return new ProducerBuilder();
    }

    public static final class ProducerBuilder {
        private String servers;
        private String topic;

        private ProducerBuilder() {
        }

        public ProducerBuilder servers(String servers) {
            this.servers = servers;
            return this;
        }

        public ProducerBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public KafkaProducer build() {
            return new KafkaProducer(this);
        }
    }
}

