/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.kafka;

import net.kut3.messaging.Message;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public final class KafkaMessage
implements Message {
    public static final String HEADER_PARTITION = "partition";
    public static final String HEADER_OFFSET = "offset";
    private final ConsumerRecord<String, String> record;

    KafkaMessage(ConsumerRecord<String, String> record) {
        this.record = record;
    }

    @Override
    public String header(String name) {
        switch (name) {
            case "partition": {
                return Integer.toString(this.record.partition());
            }
            case "offset": {
                return Long.toString(this.record.offset());
            }
        }
        return null;
    }

    @Override
    public String group() {
        return this.record.topic();
    }

    @Override
    public String id() {
        return this.record.partition() + "_" + this.record.offset();
    }

    @Override
    public String title() {
        return (String)this.record.key();
    }

    @Override
    public String body() {
        return (String)this.record.value();
    }

    public String toString() {
        return "{ group=" + this.record.topic() + ", partition=" + this.record.partition() + ", offset=" + this.record.offset() + ", title=" + (String)this.record.key() + ", body=" + (String)this.record.value() + " }";
    }
}

