/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.kafka;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.kut3.messaging.BatchConsumer;
import net.kut3.messaging.Message;
import net.kut3.messaging.kafka.KafkaMessage;
import net.kut3.messaging.kafka.OffsetMode;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

public final class KafkaConsumer {
    private final ConsumerBuilder builder;

    private KafkaConsumer(ConsumerBuilder builder) {
        this.builder = builder;
    }

    public static ConsumerBuilder newBuilder() {
        return new ConsumerBuilder();
    }

    public List<String> topics() {
        return this.builder.topics;
    }

    public void start(Consumer<Message> messageProcessor) {
        Map<String, Object> props = this.builder.properties();
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "3000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("auto.offset.reset", this.builder.offsetMode().asString());
        org.apache.kafka.clients.consumer.KafkaConsumer consumer = new org.apache.kafka.clients.consumer.KafkaConsumer(props);
        consumer.subscribe((Collection)this.builder.topics);
        block0: while (true) {
            ConsumerRecords records = consumer.poll(Duration.ofMillis(10000L));
            Iterator iterator = records.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                ConsumerRecord record = (ConsumerRecord)iterator.next();
                messageProcessor.accept(new KafkaMessage((ConsumerRecord<String, String>)record));
            }
            break;
        }
    }

    public void start(BatchConsumer<Message> messageProcessor) {
        Map<String, Object> props = this.builder.properties();
        props.put("enable.auto.commit", "true");
        props.put("auto.commit.interval.ms", "3000");
        props.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.put("auto.offset.reset", this.builder.offsetMode.asString());
        org.apache.kafka.clients.consumer.KafkaConsumer consumer = new org.apache.kafka.clients.consumer.KafkaConsumer(props);
        consumer.subscribe((Collection)this.builder.topics);
        while (true) {
            ConsumerRecords records;
            if ((records = consumer.poll(Duration.ofMillis(10000L))).isEmpty()) {
                System.out.println("No records pooled after 10000ms");
                continue;
            }
            for (ConsumerRecord record : records) {
                messageProcessor.addToBatch(new KafkaMessage((ConsumerRecord<String, String>)record));
            }
            messageProcessor.processBatch();
        }
    }

    public String toString() {
        return "{topics=" + this.builder.topics + "}";
    }

    public static final class ConsumerBuilder {
        private final Map<String, Object> props;
        private final List<String> topics;
        private OffsetMode offsetMode = OffsetMode.LATEST;

        private ConsumerBuilder() {
            this.props = new HashMap<String, Object>();
            this.topics = new ArrayList<String>();
        }

        public String servers() {
            return (String)this.props.get("bootstrap.servers");
        }

        public ConsumerBuilder servers(String value) {
            this.props.put("bootstrap.servers", value);
            return this;
        }

        public String groupId() {
            return (String)this.props.get("group.id");
        }

        public ConsumerBuilder groupId(String value) {
            this.props.put("group.id", value);
            return this;
        }

        public String clientId() {
            return (String)this.props.get("client.id");
        }

        public ConsumerBuilder clientId(String value) {
            this.props.put("group.id", value);
            return this;
        }

        public ConsumerBuilder offsetMode(OffsetMode value) {
            this.offsetMode = value;
            return this;
        }

        public OffsetMode offsetMode() {
            return this.offsetMode;
        }

        public ConsumerBuilder addTopics(List<String> topics) {
            topics.stream().filter(topic -> !this.topics.contains(topic)).forEachOrdered(topic -> this.topics.add((String)topic));
            return this;
        }

        Map<String, Object> properties() {
            return this.props;
        }

        public KafkaConsumer build() {
            return new KafkaConsumer(this);
        }
    }
}

