/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.messaging.kafka;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import net.kut3.messaging.Message;

/**
 *
 */
public final class KafkaMessage implements Message {

    /**
     *
     */
    public static final String HEADER_PARTITION = "partition";
    
    /**
     * 
     */
    public static final String HEADER_OFFSET = "offset";

    private final ConsumerRecord<String, String> record;

    /**
     *
     * @param record Record consumed
     */
    KafkaMessage(ConsumerRecord<String, String> record) {
        this.record = record;
    }

    @Override
    public String header(String name) {
        switch (name) {
            case HEADER_PARTITION:
                return Integer.toString(this.record.partition());
                
            case HEADER_OFFSET:
                return Long.toString(this.record.offset());

            default:
                return null;
        }
    }

    @Override
    public String group() {
        return this.record.topic();
    }

    @Override
    public String id() {
        return this.record.partition()
                + "_" + this.record.offset();
    }

    @Override
    public String title() {
        return this.record.key();
    }

    @Override
    public String body() {
        return this.record.value();
    }

    @Override
    public String toString() {
        return "{ group=" + this.record.topic()
                + ", partition=" + this.record.partition()
                + ", offset=" + this.record.offset()
                + ", title=" + this.record.key()
                + ", body=" + this.record.value()
                + " }";
    }
}
