/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.messaging.client;

import java.util.HashMap;
import java.util.Map;
import net.kut3.messaging.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProducerClients {
    INSTANCE;

    private static final Logger LOGGER;
    private final Map<String, Producer> producers = new HashMap<String, Producer>();

    public Producer get(String producerName) {
        return this.producers.get(producerName);
    }

    public synchronized void register(String producerName, Producer producer) {
        if (this.producers.containsKey(producerName)) {
            throw new IllegalArgumentException("Producer name '" + producerName + "' existed");
        }
        this.producers.put(producerName, producer);
        LOGGER.info("Registered '" + producerName + "' producer");
    }

    static {
        LOGGER = LoggerFactory.getLogger(ProducerClients.class);
    }
}

