/*
 * Copyright 2019 Kut3Net.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.kut3.data.elt;

import net.kut3.messaging.BatchMessageProcessor;
import net.kut3.messaging.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 *
 */
public class Kafka2DbLoader implements ELTProcess {

    private static final Logger LOGGER
            = LoggerFactory.getLogger(Kafka2MongoLoader.class);

    private final Consumer consumer;
    private final BatchMessageProcessor processor;

    /**
     *
     * @param consumer A Kafka consumer
     * @param processor Batch processor
     */
    public Kafka2DbLoader(Consumer consumer, DbBatchLoader processor) {
        this.consumer = consumer;
        this.processor = processor;
        
        LOGGER.info(this.toString());
    }

    @Override
    public void process() {
        this.consumer.start(this.processor);
    }

    @Override
    public void cancel() {
        try {
            this.consumer.close();
        } catch (RuntimeException | Error ex) {
            LOGGER.warn(this.consumer.name() + ".close() error", ex);
        }
    }

    @Override
    public final String toString() {
        return "{consumer=" + this.consumer.toString()
                + ", processor=" + this.processor.toString()
                + "}";
    }
}
