/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.data.elt;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.kut3.data.DbClient;
import net.kut3.data.elt.ELTProcess;
import net.kut3.data.mongo.MongoFunction;
import net.kut3.messaging.BatchMessageProcessor;
import net.kut3.messaging.Consumer;
import net.kut3.messaging.Message;
import net.kut3.messaging.ProcessResult;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Kafka2MongoLoader
implements ELTProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(Kafka2MongoLoader.class);
    private final Consumer consumer;
    private final DbClient dbClient;
    private final String targetDb;
    private final String targetCollection;

    public Kafka2MongoLoader(Consumer consumer, DbClient mongoClient, String targetDb, String targetCollection) {
        this.targetDb = targetDb;
        this.targetCollection = targetCollection;
        this.consumer = consumer;
        this.dbClient = mongoClient;
        LOGGER.info(this.toString());
    }

    @Override
    public void process() {
        try (Connection conn = this.dbClient.getConnection();){
            final PreparedStatement ps = conn.prepareStatement(MongoFunction.INSERT_MANY.value());
            ps.setString(1, this.targetDb);
            ps.setString(2, this.targetCollection);
            ps.setBoolean(4, true);
            final ArrayList docs = new ArrayList();
            this.consumer.start(new BatchMessageProcessor(){

                public void addToBatch(Message message) {
                    LOGGER.info("addToBatch(): " + message.bodyAsString());
                    Document tmp = Document.parse((String)message.bodyAsString());
                    Kafka2MongoLoader.this.replaceKey(tmp);
                    docs.add(tmp);
                }

                public List<ProcessResult> processBatch() {
                    try {
                        ps.setObject(3, docs);
                        ps.executeUpdate();
                    }
                    catch (SQLException sqlEx) {
                        LOGGER.error("", (Throwable)sqlEx);
                    }
                    docs.clear();
                    return new ArrayList<ProcessResult>(0);
                }
            });
        }
        catch (Error | RuntimeException | SQLException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void cancel() {
        try {
            this.consumer.close();
        }
        catch (Error | RuntimeException ex) {
            LOGGER.warn(this.consumer.name() + ".close() error", ex);
        }
        try {
            this.dbClient.close();
        }
        catch (Error | RuntimeException ex) {
            LOGGER.warn(this.dbClient.toString() + ".close() error", ex);
        }
    }

    private void replaceKey(Document doc) {
        new HashSet(doc.keySet()).forEach(k -> {
            Object o;
            if (k.contains(".")) {
                o = doc.remove(k);
                doc.put(k.replace(".", "-"), o);
            } else {
                o = doc.get(k);
            }
            if (o instanceof Document) {
                this.replaceKey((Document)o);
            }
        });
    }

    public final String toString() {
        return "{consumer=" + this.consumer.toString() + ", dbClient=" + this.dbClient.toString() + ", targetDb=" + this.targetDb + ", targetCollection=" + this.targetCollection + "}";
    }
}

