/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.runjar.mojo;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import net.kozelka.runjar.enhancer.RunjarEnhancer;
import net.kozelka.runjar.mojo.AbstractEnhancerMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="enhance-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class EnhanceJarMojo
extends AbstractEnhancerMojo {
    @Parameter(defaultValue="${project.groupId}.${project.artifactId}.Main", alias="class", property="runjar.class")
    String mainClass;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    File jar;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List artifacts = this.project.getRuntimeArtifacts();
        LinkedHashSet<File> jars = new LinkedHashSet<File>();
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) {
                throw new MojoFailureException(String.format("Artifact is not resolved: %s", artifact));
            }
            jars.add(artifact.getFile());
        }
        jars.add(this.jar);
        try {
            File bootJar = EnhanceJarMojo.locateBootJar("net.kozelka.runjar:runjar-boot");
            RunjarEnhancer enhancer = new RunjarEnhancer(this.runjarDirectory);
            enhancer.addJars(jars);
            enhancer.expandBootJar(bootJar);
            Properties properties = new Properties();
            properties.setProperty("runjar.class", this.mainClass);
            properties.setProperty("runjar.shutdown.file", "${runjar.basedir}/.shutdown.properties");
            enhancer.saveProperties(properties);
            this.finalizeJar(enhancer);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

