/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.runjar.mojo;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import net.kozelka.runjar.enhancer.RunjarEnhancer;
import net.kozelka.runjar.mojo.AbstractEnhancerMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="enhance-ant", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class EnhanceAntMojo
extends AbstractEnhancerMojo {
    @Parameter(defaultValue="${project.build.scriptSourceDirectory}")
    File antScriptsDirectory;
    @Parameter(defaultValue="main.ant.xml")
    String antFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List artifacts = this.project.getRuntimeArtifacts();
        LinkedHashSet<File> jars = new LinkedHashSet<File>();
        File bootJar = null;
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) {
                throw new MojoFailureException(String.format("Artifact is not resolved: %s", artifact));
            }
            String ga = artifact.getGroupId() + ":" + artifact.getArtifactId();
            if (ga.equals("net.kozelka.runjar:runjar-boot")) {
                bootJar = artifact.getFile();
                continue;
            }
            jars.add(artifact.getFile());
        }
        try {
            if (bootJar == null) {
                bootJar = EnhanceAntMojo.locateBootJar("net.kozelka.runjar:runjar-boot");
            }
            RunjarEnhancer enhancer = new RunjarEnhancer(this.runjarDirectory);
            enhancer.addJars(jars);
            enhancer.addScripts(this.antScriptsDirectory);
            enhancer.expandBootJar(bootJar);
            Properties properties = new Properties();
            properties.setProperty("runjar.class", "org.apache.tools.ant.Main");
            properties.setProperty("runjar.preargs", ",-f,${runjar.basedir}/" + this.antFile);
            properties.setProperty("runjar.shutdown.file", "${runjar.basedir}/.shutdown.properties");
            enhancer.saveProperties(properties);
            enhancer.compress(this.runnableJar);
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

