/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.runjar.mojo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import net.kozelka.runjar.enhancer.RunjarEnhancer;
import net.kozelka.runjar.mojo.EnhanceAntMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnhancerMojo
extends AbstractMojo {
    protected final String bootArtifactGA = "net.kozelka.runjar:runjar-boot";
    @Parameter(defaultValue="${project.build.directory}/runjar")
    File runjarDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}-run.jar")
    File runnableJar;
    @Parameter(defaultValue="true")
    boolean attach;
    @Parameter(defaultValue="run")
    String classifier;
    @Component
    MavenProjectHelper helper;
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;

    protected static File locateBootJar(String bootArtifactGA) throws IOException {
        String[] ga = bootArtifactGA.split(":");
        String res = "/META-INF/maven/" + ga[0] + "/" + ga[1] + "/pom.properties";
        String path = EnhanceAntMojo.class.getResource(res).getPath();
        String fileStr = new URL(path.split("!")[0]).getPath();
        File file = new File(fileStr);
        if (!file.exists()) {
            throw new FileNotFoundException(fileStr);
        }
        return file;
    }

    private void littleDiagnosticHack() throws MojoExecutionException {
        try {
            this.show("runtime", this.project.getRuntimeArtifacts());
            this.show("plugins", this.project.getPluginArtifacts());
            this.show("compile", this.project.getCompileArtifacts());
            this.show("artifacts", this.project.getArtifacts());
            this.show("dep.artifacts", this.project.getDependencyArtifacts());
            this.show("compile.cpe", this.project.getCompileClasspathElements());
            this.show("runtime.cpe", this.project.getRuntimeClasspathElements());
            this.show("runtime.deps", this.project.getRuntimeDependencies());
            this.show("ep.runtime", this.project.getExecutionProject().getRuntimeArtifacts());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void show(String prefix, Collection<Artifact> artifacts) {
        System.out.println("Showing " + prefix);
        for (Artifact o : artifacts) {
            System.out.println(String.format("%s %s : %s", prefix, o.getClass(), o));
        }
        System.out.println();
    }

    protected void finalizeJar(RunjarEnhancer enhancer) throws IOException {
        enhancer.compress(this.runnableJar);
        if (this.attach) {
            String extension = FileUtils.extension((String)this.runnableJar.getName());
            this.helper.attachArtifact(this.project, extension, this.classifier, this.runnableJar);
        }
    }
}

