/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.runjar.enhancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunjarEnhancer {
    final File workdir;

    public RunjarEnhancer(File workdir) {
        this.workdir = workdir;
    }

    public void addJars(Set<File> jars) throws IOException {
        File libDirectory = new File(this.workdir, "lib");
        libDirectory.mkdirs();
        for (File jar : jars) {
            File lib = new File(libDirectory, jar.getName());
            FileUtils.copyFile((File)jar, (File)lib);
        }
    }

    public void expandBootJar(File bootJar) {
        ZipUnArchiver unarchiver = new ZipUnArchiver();
        unarchiver.enableLogging((Logger)new ConsoleLogger(4, "runjar"));
        unarchiver.setSourceFile(bootJar);
        unarchiver.setDestDirectory(this.workdir);
        unarchiver.extract();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProperties(Properties properties) throws IOException {
        if (properties.getProperty("runjar.class") == null) {
            throw new IllegalArgumentException("Missing required property: runjar.class");
        }
        FileOutputStream os = new FileOutputStream(new File(this.workdir, "META-INF/runjar.properties"));
        try {
            properties.store(os, "Generated by RUNJAR - see http://code.kozelka.net/runjar");
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public void addScripts(File antScriptsDirectory) throws IOException {
        FileUtils.copyDirectory((File)antScriptsDirectory, (File)this.workdir);
    }

    public void compress(File jar) throws IOException {
        System.out.println("Compressing: " + jar);
        ZipArchiver archiver = new ZipArchiver();
        archiver.setDestFile(jar);
        archiver.addDirectory(this.workdir);
        archiver.createArchive();
    }
}

