package net.kozelka.runjar.enhancer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import net.kozelka.runjar.boot.RunjarProperties;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.FileUtils;

/**
 * Enhances input jar with files needed to make it an executable one, and creates output jar.
 * This should be the enhancing engine, shared among all interfaces like maven, ant, cli etc.
 * @author Petr Kozelka
 */
public class RunjarEnhancer {
    final File workdir;

    public RunjarEnhancer(File workdir) {
        this.workdir = workdir;
    }

    public void addJars(Set<File> jars) throws IOException {
        final File libDirectory = new File(workdir, "lib");
        libDirectory.mkdirs();
        for (File jar : jars) {
            final File lib = new File(libDirectory, jar.getName());
            FileUtils.copyFile(jar, lib);
        }
    }

    public void expandBootJar(File bootJar) {
        final ZipUnArchiver unarchiver = new ZipUnArchiver();
        unarchiver.enableLogging(new ConsoleLogger(Logger.LEVEL_FATAL, "runjar"));
        unarchiver.setSourceFile(bootJar);
        unarchiver.setDestDirectory(workdir);
        unarchiver.extract();
    }

    public void saveProperties(Properties properties) throws IOException {
        if (properties.getProperty(RunjarProperties.PROP_META_CLASS) == null) {
            throw new IllegalArgumentException("Missing required property: " + RunjarProperties.PROP_META_CLASS);
        }
        final OutputStream os = new FileOutputStream(new File(workdir, RunjarProperties.RUNJAR_PROPERTIES_RES));
        try {
            properties.store(os, "Generated by RUNJAR - see http://code.kozelka.net/runjar");
        } finally {
            os.close();
        }
    }

    public void addScripts(File antScriptsDirectory) throws IOException {
        FileUtils.copyDirectory(antScriptsDirectory, workdir);
    }

    public void compress(File jar) throws IOException {
        System.out.println("Compressing: " + jar);
        final ZipArchiver archiver = new ZipArchiver();
        archiver.setDestFile(jar);
        archiver.addDirectory(workdir);
        archiver.createArchive();

    }
}
