/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.gitsite.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ShellExecutor {
    private File workingDirectory;
    private StreamConsumer info = new DefaultConsumer();
    private StreamConsumer stdout = new DefaultConsumer();
    private StreamConsumer stderr = new DefaultConsumer();

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setInfo(StreamConsumer info) {
        this.info = info;
    }

    public void setStdout(StreamConsumer stdout) {
        this.stdout = stdout;
    }

    public void setStderr(StreamConsumer stderr) {
        this.stderr = stderr;
    }

    public void exec(String executable, String ... args) throws CommandLineException {
        Commandline cl = new Commandline();
        if (this.workingDirectory != null) {
            cl.setWorkingDirectory(this.workingDirectory);
        }
        cl.setExecutable(executable);
        cl.addArguments(args);
        int clHash = cl.toString().hashCode();
        this.info.consumeLine(String.format("Executing: %s [#%x]", cl.toString(), clHash));
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)this.stdout, (StreamConsumer)this.stderr);
        if (exitCode != 0) {
            throw new CommandLineException(String.format("%s [#%x] returned with exit code '%d'", executable, clHash, exitCode));
        }
    }

    public Result execWithResult(String executable, String ... args) throws CommandLineException {
        Result result = new Result();
        this.execWithResult(result, executable, args);
        return result;
    }

    public void execWithResult(final Result result, String executable, String ... args) throws CommandLineException {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(this.workingDirectory);
        cl.setExecutable(executable);
        cl.addArguments(args);
        this.info.consumeLine(String.format("Executing: %s", cl));
        result.exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)new StreamConsumer(){

            public void consumeLine(String line) {
                ShellExecutor.this.stdout.consumeLine(line);
                result.stdoutLines.add(line);
            }
        }, (StreamConsumer)new StreamConsumer(){

            public void consumeLine(String line) {
                ShellExecutor.this.stderr.consumeLine(line);
                result.stderrLines.add(line);
            }
        });
        this.info.consumeLine(String.format("%s exited with code %d", executable, result.exitCode));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result {
        private int exitCode;
        private final List<String> stdoutLines = new ArrayList<String>();
        private final List<String> stderrLines = new ArrayList<String>();

        public int getExitCode() {
            return this.exitCode;
        }

        public List<String> getStdoutLines() {
            return this.stdoutLines;
        }

        public List<String> getStderrLines() {
            return this.stderrLines;
        }

        public boolean stdoutContains(Pattern message) {
            return this.contains(this.stdoutLines, message);
        }

        public boolean stderrContains(Pattern message) {
            return this.contains(this.stderrLines, message);
        }

        private boolean contains(List<String> lines, Pattern message) {
            for (String line : lines) {
                String lline = line.toLowerCase();
                Matcher matcher = message.matcher(lline);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
    }
}

