/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.gitsite.mojo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.kozelka.gitsite.mojo.AbstractMultiModuleMojo;
import net.kozelka.gitsite.utils.ShellExecutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.SITE_DEPLOY)
public class GitSiteDeployMojo
extends AbstractMultiModuleMojo {
    @Parameter(defaultValue="${project.build.directory}/staging", property="gitsite.inputDirectory")
    File inputDirectory;
    @Parameter(defaultValue="gitsite", property="gitsite.branch")
    String gitBranch;
    @Parameter(defaultValue="${project.scm.developerConnection}", property="gitsite.gitScmUrl")
    String gitScmUrl;
    @Parameter(defaultValue="true", property="gitsite.keepHistory")
    boolean keepHistory;
    @Parameter(defaultValue="Publishing ${project.artifactId} site with %d files", property="gitsite.commitMessage")
    String commitMessage;
    @Parameter(defaultValue="${project.build.directory}/gitsite-deploy.log")
    File logfile;
    @Parameter(property="gitsite.subcontext")
    String subcontext;
    @Parameter(defaultValue=".gitsite.index.txt", property="gitsite.index")
    String index;
    @Parameter(defaultValue="VERSION,BRANCH", property="gitsite.roots")
    String roots;
    private static final String SCM_PREFIX = "scm:git:";

    private void validate() throws MojoExecutionException {
        if (!this.gitScmUrl.startsWith(SCM_PREFIX)) {
            throw new MojoExecutionException(String.format("gitScmUrl must start with prefix '%s'", SCM_PREFIX));
        }
    }

    protected void executeInRootModule() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("ROOT MODULE - executionRootDirectory = " + this.executionRootDirectory));
        this.validate();
        this.saveParameters("inputDirectory", "gitBranch", "gitScmUrl", "keepHistory", "logfile", "commitMessage");
    }

    protected void executeInLastModule() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("LAST MODULE - executionRootDirectory = " + this.executionRootDirectory));
        File paramFile = this.loadParameters();
        this.gitSiteDeploy();
        if (!paramFile.delete()) {
            paramFile.deleteOnExit();
        }
    }

    private void gitSiteDeploy() throws MojoExecutionException, MojoFailureException {
        block12: {
            File workDir = new File(this.inputDirectory.getAbsolutePath() + ".work");
            workDir.mkdirs();
            ShellExecutor shell = this.getShellExecutor();
            shell.setWorkingDirectory(workDir);
            String gitRemoteUrl = this.gitScmUrl.substring(SCM_PREFIX.length());
            try {
                String localBranch;
                boolean pushForce = !this.keepHistory;
                this.subcontext = this.subcontext == null ? "" : this.subcontext;
                ShellExecutor.Result cloneResult = shell.execWithResult("git", "clone", "--branch", this.gitBranch, "--single-branch", gitRemoteUrl, ".");
                if (cloneResult.getExitCode() == 0) {
                    localBranch = this.gitBranch;
                } else {
                    boolean branchNotFound = cloneResult.stderrContains(Pattern.compile(".*could not find remote branch.*\\|.* not found in upstream .*"));
                    if (!branchNotFound) {
                        throw new MojoExecutionException(String.format("git exited with code %d", cloneResult.getExitCode()));
                    }
                    this.getLog().info((CharSequence)String.format("Branch '%s' does not exist in '%s' - will be created", this.gitBranch, gitRemoteUrl));
                    pushForce = true;
                    localBranch = "master";
                }
                File targetArea = new File(workDir, this.subcontext).getCanonicalFile();
                targetArea.mkdirs();
                this.getLog().debug((CharSequence)("Moving site into " + targetArea));
                StringBuilder excludes = new StringBuilder(".git/**");
                StringTokenizer tok = new StringTokenizer(this.roots, ",");
                while (tok.hasMoreTokens()) {
                    String root = tok.nextToken();
                    excludes.append(",");
                    excludes.append(root);
                    excludes.append("/**");
                }
                List filesToDelete = FileUtils.getFiles((File)targetArea.getAbsoluteFile(), null, (String)excludes.toString());
                this.getLog().info((CharSequence)String.format("Deleting %d files - excluded '%s'", filesToDelete.size(), excludes));
                for (File file : filesToDelete) {
                    this.getLog().debug((CharSequence)("Deleting file: " + file));
                    FileUtils.fileDelete((String)file.getAbsolutePath());
                }
                FileUtils.copyDirectoryStructure((File)this.inputDirectory, (File)targetArea);
                GitSiteDeployMojo.updateIndex(new File(workDir, this.index), this.subcontext);
                FileUtils.fileWrite((String)new File(workDir, ".gitattributes").getAbsolutePath(), (String)"* text=auto\n");
                shell.exec("git", "add", "-A", ".");
                int fileCount = FileUtils.getFiles((File)this.inputDirectory, null, null, (boolean)false).size();
                ShellExecutor.Result commitResult = shell.execWithResult("git", "commit", "-am", String.format(this.commitMessage, fileCount));
                if (commitResult.getExitCode() == 0) {
                    if (pushForce) {
                        shell.exec("git", "push", "origin", localBranch + ":" + this.gitBranch, "--force", "--set-upstream");
                    } else {
                        shell.exec("git", "push", "origin", localBranch + ":" + this.gitBranch);
                    }
                    break block12;
                }
                if (commitResult.stdoutContains(Pattern.compile("nothing to commit.*"))) {
                    this.getLog().info((CharSequence)"Nothing to commit");
                    break block12;
                }
                throw new MojoExecutionException(String.format("git commit exited with code %d", commitResult.getExitCode()));
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("git publishing error", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("git publishing error", (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateIndex(File indexFile, String newSubcontext) throws IOException {
        String content = indexFile.exists() ? FileUtils.fileRead((File)indexFile, (String)"UTF-8") : "";
        ArrayList<String> subdirIndex = new ArrayList<String>(Arrays.asList(content.split("\n")));
        subdirIndex.add(newSubcontext);
        System.out.println("newSubcontext = " + newSubcontext);
        System.out.println("subdirIndex = " + subdirIndex);
        Collections.sort(subdirIndex);
        BufferedWriter wr = new BufferedWriter(new FileWriter(indexFile));
        try {
            for (String subcontext : subdirIndex) {
                if (subcontext.trim().length() == 0) continue;
                File subdirVerify = new File(indexFile.getParentFile(), "." + subcontext).getCanonicalFile();
                if (subdirVerify.isDirectory()) {
                    wr.write(subcontext);
                    wr.newLine();
                    continue;
                }
                System.err.printf("WARN: removing %s from index%n", subcontext);
            }
        }
        finally {
            wr.close();
        }
    }

    private ShellExecutor getShellExecutor() {
        ShellExecutor shell = new ShellExecutor();
        shell.setInfo(new StreamConsumer(){

            public void consumeLine(String line) {
                GitSiteDeployMojo.this.getLog().info((CharSequence)line);
                GitSiteDeployMojo.this.filelog("INFO", line);
            }
        });
        shell.setStderr(new StreamConsumer(){

            public void consumeLine(String line) {
                GitSiteDeployMojo.this.getLog().error((CharSequence)line);
                GitSiteDeployMojo.this.filelog("ERROR", line);
            }
        });
        shell.setStdout(new StreamConsumer(){

            public void consumeLine(String line) {
                GitSiteDeployMojo.this.getLog().warn((CharSequence)line);
                GitSiteDeployMojo.this.filelog("WARN", line);
            }
        });
        shell.setWorkingDirectory(this.inputDirectory);
        return shell;
    }

    private void filelog(String severity, String line) {
        try {
            FileUtils.fileAppend((String)this.logfile.getAbsolutePath(), (String)String.format("%6s %s%n", severity, line));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

