/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.gitsite.mojo;

import java.io.File;
import java.io.IOException;
import net.kozelka.gitsite.mojo.AbstractMultiModuleMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="deploy", defaultPhase=LifecyclePhase.SITE_DEPLOY, requiresProject=true)
public class GitSiteDeployMojo
extends AbstractMultiModuleMojo {
    @Parameter(defaultValue="${project.build.directory}/staging", property="gitsite.inputDirectory")
    File inputDirectory;
    @Parameter(defaultValue="gitsite", property="gitsite.branch")
    String gitBranch;
    @Parameter(defaultValue="${project.scm.developerConnection}", property="gitsite.gitScmUrl")
    String gitScmUrl;
    @Parameter(defaultValue="true", property="gitsite.keepHistory")
    boolean keepHistory;
    @Parameter(defaultValue="${project.build.directory}/gitsite-deploy.log")
    File logfile;
    private static final String SCM_PREFIX = "scm:git:";

    private void validate() throws MojoExecutionException {
        if (!this.gitScmUrl.startsWith(SCM_PREFIX)) {
            throw new MojoExecutionException(String.format("gitScmUrl must start with prefix '%s'", SCM_PREFIX));
        }
    }

    protected void executeInRootModule() throws MojoExecutionException, MojoFailureException {
        System.out.println("ROOT MODULE");
        System.out.println("executionRootDirectory = " + this.executionRootDirectory);
        this.validate();
        this.saveParameters("inputDirectory", "gitBranch", "gitScmUrl", "keepHistory", "logfile");
    }

    protected void executeInLastModule() throws MojoExecutionException, MojoFailureException {
        System.out.println("LAST MODULE");
        System.out.println("executionRootDirectory = " + this.executionRootDirectory);
        File paramFile = this.loadParameters();
        this.gitSiteDeploy();
        FileUtils.fileDelete((String)paramFile.getAbsolutePath());
    }

    private void gitSiteDeploy() throws MojoExecutionException, MojoFailureException {
        try {
            String gitRemoteUrl = this.gitScmUrl.substring(SCM_PREFIX.length());
            FileUtils.deleteDirectory((File)new File(this.inputDirectory, ".git"));
            FileUtils.fileWrite((String)new File(this.inputDirectory, ".gitattributes").getAbsolutePath(), (String)"* text=auto\n");
            int fileCount = FileUtils.getFiles((File)this.inputDirectory, null, null, (boolean)false).size();
            if (this.keepHistory) {
                String origDir = this.inputDirectory.getAbsolutePath() + ".orig";
                this.git("clone", "--branch", this.gitBranch, "--single-branch", gitRemoteUrl, origDir);
                FileUtils.rename((File)new File(origDir, ".git"), (File)new File(this.inputDirectory, ".git"));
                this.git("add", "-A", ".");
                this.git("commit", "-am", String.format("Updating site with %d files", fileCount));
                this.git("push", gitRemoteUrl);
            } else {
                this.git("init");
                this.git("add", "-A", ".");
                this.git("commit", "-am", String.format("Creating site with %d files", fileCount));
                this.git("push", gitRemoteUrl, "+master:" + this.gitBranch);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("git publishing error", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("git publishing error", (Exception)e);
        }
    }

    private void git(String ... args) throws CommandLineException, MojoFailureException {
        Commandline cl = new Commandline();
        cl.setWorkingDirectory(this.inputDirectory);
        cl.setExecutable("git");
        cl.addArguments(args);
        StreamConsumer stdout = new StreamConsumer(){

            public void consumeLine(String line) {
                GitSiteDeployMojo.this.debug(line);
            }
        };
        StreamConsumer stderr = new StreamConsumer(){

            public void consumeLine(String line) {
                GitSiteDeployMojo.this.warn(line);
            }
        };
        this.info(String.format("Executing: %s", cl));
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        if (exitCode != 0) {
            throw new MojoFailureException(String.format("git returned with exit code '%d'", exitCode));
        }
    }

    private void filelog(String severity, String line) {
        try {
            FileUtils.fileAppend((String)this.logfile.getAbsolutePath(), (String)String.format("%6s %s%n", severity, line));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void debug(String line) {
        this.getLog().debug((CharSequence)line);
        this.filelog("DEBUG", line);
    }

    private void warn(String line) {
        this.getLog().warn((CharSequence)line);
        this.filelog("WARN", line);
    }

    private void info(String line) {
        this.getLog().info((CharSequence)line);
        this.filelog("INFO", line);
    }
}

