/*
 * Decompiled with CFR 0.152.
 */
package net.kozelka.gitsite.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultiModuleMojo
extends AbstractMojo {
    @Parameter(property="reactorProjects", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession mavenSession;
    protected String executionRootDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int size;
        this.executionRootDirectory = this.mavenSession.getExecutionRootDirectory();
        if (this.project == this.reactorProjects.get(0)) {
            this.executeInFirstModule();
        }
        if (this.project.isExecutionRoot()) {
            this.executeInRootModule();
        }
        if (this.project == this.reactorProjects.get((size = this.reactorProjects.size()) - 1)) {
            this.executeInLastModule();
        }
        this.executeInEachModule();
    }

    private File getParamFile() {
        return new File(this.executionRootDirectory, "." + ((Object)((Object)this)).getClass().getName() + ".properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File saveParameters(String ... fieldNames) throws MojoExecutionException {
        File paramFile = this.getParamFile();
        try {
            Properties properties = new Properties();
            for (String fieldName : fieldNames) {
                Field field = ((Object)((Object)this)).getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get((Object)this);
                if (value == null) continue;
                properties.put(fieldName, value + "");
            }
            FileOutputStream os = new FileOutputStream(paramFile);
            try {
                properties.store(os, ((Object)((Object)this)).getClass().getName());
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (NoSuchFieldException e) {
            throw new MojoExecutionException("Cannot save parameters", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Cannot save parameters", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot save parameters", (Exception)e);
        }
        return paramFile;
    }

    protected File loadParameters() throws MojoExecutionException {
        File paramFile = this.getParamFile();
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(paramFile));
            Set<Object> keys = properties.keySet();
            for (Object key : keys) {
                String fieldName = (String)key;
                Field field = ((Object)((Object)this)).getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                String value = properties.getProperty(fieldName);
                field.set((Object)this, this.fromString(value, field.getType()));
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Cannot load parameters", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load parameters", (Exception)e);
        }
        catch (NoSuchFieldException e) {
            throw new MojoExecutionException("Cannot load parameters", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Cannot load parameters", (Exception)e);
        }
        return paramFile;
    }

    private Object fromString(String s, Class<?> toType) {
        if (toType.equals(Boolean.class) || toType.equals(Boolean.TYPE)) {
            return Boolean.valueOf(s);
        }
        if (toType.equals(File.class)) {
            return new File(s);
        }
        return s;
    }

    protected void executeInEachModule() throws MojoExecutionException, MojoFailureException {
    }

    protected void executeInFirstModule() throws MojoExecutionException, MojoFailureException {
    }

    protected void executeInRootModule() throws MojoExecutionException, MojoFailureException {
    }

    protected void executeInLastModule() throws MojoExecutionException, MojoFailureException {
    }
}

