/*
 * Decompiled with CFR 0.152.
 */
package net.kodein.cup.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0001\u001bB!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u00012\u0006\u0010\u0019\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/kodein/cup/utils/LRUCache;", "K", "", "V", "maxCount", "", "maxSize", "", "initialCount", "<init>", "(IJI)V", "getMaxCount", "()I", "getMaxSize", "()J", "map", "Ljava/util/LinkedHashMap;", "Lnet/kodein/cup/utils/LRUCache$Entry;", "totalSize", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "put", "", "value", "size", "(Ljava/lang/Object;Ljava/lang/Object;J)V", "Entry", "cup"})
@StabilityInferred(parameters=0)
public final class LRUCache<K, V> {
    private final int maxCount;
    private final long maxSize;
    @NotNull
    private final LinkedHashMap<K, Entry<V>> map;
    private long totalSize;
    public static final int $stable = 8;

    public LRUCache(int maxCount, long maxSize, int initialCount) {
        this.maxCount = maxCount;
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(initialCount);
    }

    public /* synthetic */ LRUCache(int n, long l, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = n / 10;
        }
        this(n, l, n2);
    }

    public final int getMaxCount() {
        return this.maxCount;
    }

    public final long getMaxSize() {
        return this.maxSize;
    }

    @Nullable
    public final V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Entry entry = (Entry)this.map.remove(key);
        if (entry != null) {
            this.map.put(key, entry);
        }
        Entry entry2 = entry;
        return (V)(entry2 != null ? entry2.getValue() : null);
    }

    public final void put(@NotNull K key, @NotNull V value, long size) {
        Entry previous;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Entry entry = previous = (Entry)this.map.remove(key);
        this.totalSize -= entry != null ? entry.getSize() : 0L;
        this.map.put(key, new Entry<V>(value, size));
        this.totalSize += size;
        if (((Map)this.map).size() > this.maxCount || this.totalSize > this.maxSize) {
            Iterator it = ((Map)this.map).entrySet().iterator();
            while (it.hasNext() && ((Map)this.map).size() > this.maxCount || this.totalSize > this.maxSize) {
                Map.Entry removed = it.next();
                it.remove();
                this.totalSize -= ((Entry)removed.getValue()).getSize();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0003\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lnet/kodein/cup/utils/LRUCache$Entry;", "V", "", "value", "size", "", "<init>", "(Ljava/lang/Object;J)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getSize", "()J", "cup"})
    private static final class Entry<V> {
        private final V value;
        private final long size;

        public Entry(V value, long size) {
            this.value = value;
            this.size = size;
        }

        public final V getValue() {
            return this.value;
        }

        public final long getSize() {
            return this.size;
        }
    }
}

