/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.klakegg.pkix.ocsp.CertificateIssuer;
import net.klakegg.pkix.ocsp.OcspException;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;

class OcspRequest {
    private List<Extension> extensions = new ArrayList<Extension>();
    private List<BigInteger> certificates = new ArrayList<BigInteger>();
    private ASN1OctetString issuerNameHash;
    private ASN1OctetString issuerKeyHash;
    private AlgorithmIdentifier algorithmIdentifier;

    OcspRequest() {
    }

    public void setIssuer(CertificateIssuer certificateIssuer) {
        this.issuerNameHash = new DEROctetString(certificateIssuer.getIssuerNameHash());
        this.issuerKeyHash = new DEROctetString(certificateIssuer.getIssuerKeyHash());
        this.algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(certificateIssuer.getAlgorithmIdentifier()));
    }

    public void addNonce() {
        byte[] nonce = new byte[16];
        ThreadLocalRandom.current().nextBytes(nonce);
        this.addExtension(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce)));
    }

    public void addExtension(Extension extension) {
        this.extensions.add(extension);
    }

    public void addCertificates(BigInteger ... serialNumbers) {
        Collections.addAll(this.certificates, serialNumbers);
    }

    protected byte[] generateRequest() throws OcspException {
        try {
            OCSPReqBuilder reqBuilder = new OCSPReqBuilder();
            for (BigInteger certificate : this.certificates) {
                reqBuilder.addRequest(new CertificateID(new CertID(this.algorithmIdentifier, this.issuerNameHash, this.issuerKeyHash, new ASN1Integer(certificate))));
            }
            if (this.extensions.size() > 0) {
                reqBuilder.setRequestExtensions(new Extensions(this.extensions.toArray(new Extension[this.extensions.size()])));
            }
            return reqBuilder.build().getEncoded();
        }
        catch (IOException | OCSPException e) {
            throw new OcspException("Exception while creating OCSP request: '%s'", e, e.getMessage());
        }
    }
}

