/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class OcspDigestOutputStream
extends OutputStream {
    private MessageDigest messageDigest;

    public OcspDigestOutputStream(String algorithm) {
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.messageDigest.update((byte)b);
    }

    public byte[] getDigest() {
        return this.messageDigest.digest();
    }

    public byte[] calculate(byte[] bytes) throws IOException {
        this.write(bytes);
        return this.getDigest();
    }
}

