/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import net.klakegg.pkix.ocsp.OcspDigestOutputStream;
import net.klakegg.pkix.ocsp.OcspException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;

public class CertificateIssuer
implements Serializable {
    private static final long serialVersionUID = -5864866954149163735L;
    private static final String ALGORITHM_IDENTIFIER = "1.3.14.3.2.26";
    private byte[] issuerNameHash;
    private byte[] issuerKeyHash;

    public static CertificateIssuer generate(X509Certificate certificate) throws OcspException {
        try {
            OcspDigestOutputStream digestCalculator = new OcspDigestOutputStream("SHA-1");
            X509CertificateHolder issuerHolder = new X509CertificateHolder(certificate.getEncoded());
            byte[] issuerNameHash = digestCalculator.calculate(issuerHolder.toASN1Structure().getSubject().getEncoded("DER"));
            byte[] issuerKeyHash = digestCalculator.calculate(issuerHolder.getSubjectPublicKeyInfo().getPublicKeyData().getBytes());
            return new CertificateIssuer(issuerNameHash, issuerKeyHash);
        }
        catch (Exception e) {
            throw new OcspException("Exception while preparing issuer data: '%s'", (Throwable)e, e.getMessage());
        }
    }

    public static CertificateIssuer generate(CertificateID certificateID) {
        return new CertificateIssuer(certificateID.getIssuerNameHash(), certificateID.getIssuerKeyHash());
    }

    public CertificateIssuer(byte[] issuerNameHash, byte[] issuerKeyHash) {
        this.issuerNameHash = issuerNameHash;
        this.issuerKeyHash = issuerKeyHash;
    }

    public String getAlgorithmIdentifier() {
        return ALGORITHM_IDENTIFIER;
    }

    public byte[] getIssuerNameHash() {
        return this.issuerNameHash;
    }

    public byte[] getIssuerKeyHash() {
        return this.issuerKeyHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateIssuer that = (CertificateIssuer)o;
        if (!Arrays.equals(this.issuerNameHash, that.issuerNameHash)) {
            return false;
        }
        return Arrays.equals(this.issuerKeyHash, that.issuerKeyHash);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.issuerNameHash);
        result = 31 * result + Arrays.hashCode(this.issuerKeyHash);
        return result;
    }
}

