package net.kigawa.renlin.tag

import net.kigawa.renlin.w3c.category.integration.FlowHeadingPalpable
    import net.kigawa.renlin.w3c.category.native.PhrasingContent
import net.kigawa.renlin.dsl.DslBase
import net.kigawa.renlin.dsl.StatedDsl
import net.kigawa.renlin.component.TagComponent1
import net.kigawa.renlin.component.Component
import net.kigawa.renlin.w3c.element.TagNode
import net.kigawa.renlin.state.DslState
import net.kigawa.renlin.w3c.category.native.H4Category
import net.kigawa.renlin.w3c.category.dsl.PhrasingContentDsl


/**
 * HTML <h4> element
 * 
 * model.Categories: FlowContent, HeadingContent, PalpableContent
 */
class H4Dsl(dslState: DslState): 
    DslBase<PhrasingContent>(dslState),
    StatedDsl<PhrasingContent>,
    PhrasingContentDsl<PhrasingContent> {
    override fun applyElement(element: TagNode): ()->Unit {
        return {}
    }
}

val h4 = TagComponent1(H4, ::H4Dsl)

object H4 : Tag<H4Category> {
    override val name: String
        get() = "h4"
}