package net.kigawa.renlin.tag

import net.kigawa.renlin.w3c.category.integration.FlowPalpable
import net.kigawa.renlin.dsl.DslBase
import net.kigawa.renlin.dsl.StatedDsl
import net.kigawa.renlin.component.TagComponent1
import net.kigawa.renlin.component.Component
import net.kigawa.renlin.w3c.element.TagNode
import net.kigawa.renlin.state.DslState
import net.kigawa.renlin.w3c.category.native.MainCategory
import net.kigawa.renlin.w3c.category.ContentCategory

/**
 * HTML <main> element
 * 
 * model.Categories: FlowContent, PalpableContent
 */
class MainDsl(dslState: DslState): 
    DslBase<ContentCategory>(dslState),
    StatedDsl<ContentCategory> {
    override fun applyElement(element: TagNode): ()->Unit {
        return {}
    }
}

val main = TagComponent1(Main, ::MainDsl)

object Main : Tag<MainCategory> {
    override val name: String
        get() = "main"
}