package net.kigawa.renlin.tag

import net.kigawa.renlin.w3c.category.integration.FlowPalpablePhrasing
import net.kigawa.renlin.dsl.DslBase
import net.kigawa.renlin.dsl.StatedDsl
import net.kigawa.renlin.component.TagComponent1
import net.kigawa.renlin.component.Component
import net.kigawa.renlin.w3c.element.TagNode
import net.kigawa.renlin.state.DslState
import net.kigawa.renlin.w3c.category.native.EmCategory
import net.kigawa.renlin.w3c.category.ContentCategory

/**
 * HTML <em> element
 * 
 * model.Categories: FlowContent, PhrasingContent, PalpableContent
 */
class EmDsl(dslState: DslState): 
    DslBase<ContentCategory>(dslState),
    StatedDsl<ContentCategory> {
    override fun applyElement(element: TagNode): ()->Unit {
        return {}
    }
}

val em = TagComponent1(Em, ::EmDsl)

object Em : Tag<EmCategory> {
    override val name: String
        get() = "em"
}