package net.kigawa.renlin.tag

import net.kigawa.renlin.w3c.category.integration.FlowHeadingPalpableIntegration
import net.kigawa.renlin.dsl.DslBase
import net.kigawa.renlin.dsl.StatedDsl
import net.kigawa.renlin.component.TagComponent1
import net.kigawa.renlin.w3c.element.TagNode
import net.kigawa.renlin.state.DslState
import net.kigawa.renlin.w3c.category.ContentCategory

/**
 * HTML <h4> element
 * 
 * model.Categories: FlowContent, HeadingContent, PalpableContent
 */
class H4Dsl(dslState: DslState): 
    DslBase<ContentCategory>(dslState),
    StatedDsl<ContentCategory> {
    override fun applyElement(element: TagNode): ()->Unit {
        return {}
    }
}

val h4 = TagComponent1(H4, ::H4Dsl)

object H4 : Tag<FlowHeadingPalpableIntegration> {
    override val name: String
        get() = "h4"
}