package net.kigawa.renlin.tag

import net.kigawa.renlin.w3c.category.native.FlowHeadingUnion

import net.kigawa.renlin.dsl.DslBase
import net.kigawa.renlin.dsl.StatedDsl
import net.kigawa.renlin.component.TagComponent1
import net.kigawa.renlin.w3c.element.TagNode
import net.kigawa.renlin.state.DslState
import net.kigawa.renlin.w3c.category.ContentCategory

/**
 * HTML <hgroup> element
 * 
 * model.Categories: FlowContent, HeadingContent
 */
class HgroupDsl(dslState: DslState): 
    DslBase<ContentCategory>(dslState),
    StatedDsl<ContentCategory> {
    override fun applyElement(element: TagNode): ()->Unit {
        return {}
    }
}

val hgroup = TagComponent1(Hgroup, ::HgroupDsl)

object Hgroup : Tag<FlowHeadingUnion> {
    override val name: String
        get() = "hgroup"
}