/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.concurrent.TimeUnit;
import kieker.model.system.model.AbstractMessage;
import kieker.tools.trace.analysis.filter.visualization.graph.Color;
import kieker.visualization.trace.dependency.graph.AbstractNodeDecorator;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;

public class ResponseTimeColorNodeDecorator
extends AbstractNodeDecorator {
    private static final TimeUnit DISPLAY_TIMEUNIT = TimeUnit.MILLISECONDS;
    private static final Color COLOR = Color.RED;
    private final int threshold;

    public ResponseTimeColorNodeDecorator(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void processMessage(AbstractMessage message, DependencyGraphNode<?> sourceNode, DependencyGraphNode<?> targetNode, TimeUnit timeunit) {
        if (sourceNode.equals(targetNode)) {
            return;
        }
        long responseTime = message.getReceivingExecution().getTout() - message.getReceivingExecution().getTin();
        int convertedResponseTime = (int)DISPLAY_TIMEUNIT.convert(responseTime, timeunit);
        if (convertedResponseTime > this.threshold) {
            targetNode.setColor(COLOR);
        }
    }
}

