/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.dependency.graph;

import java.util.concurrent.TimeUnit;
import kieker.model.repository.AssemblyComponentOperationPairFactory;
import kieker.model.repository.AssemblyRepository;
import kieker.model.repository.OperationRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.Operation;
import kieker.model.system.model.SynchronousReplyMessage;
import kieker.model.system.model.util.AssemblyComponentOperationPair;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraph;
import kieker.visualization.trace.dependency.graph.AbstractDependencyGraphFilter;
import kieker.visualization.trace.dependency.graph.DependencyGraphNode;
import kieker.visualization.trace.dependency.graph.OperationAssemblyDependencyGraph;

public class OperationDependencyGraphAssemblyFilter
extends AbstractDependencyGraphFilter<AssemblyComponentOperationPair> {
    public OperationDependencyGraphAssemblyFilter(SystemModelRepository repository, TimeUnit timeUnit) {
        super(repository, timeUnit, new OperationAssemblyDependencyGraph(new AssemblyComponentOperationPair(0, OperationRepository.ROOT_OPERATION, AssemblyRepository.ROOT_ASSEMBLY_COMPONENT)));
    }

    protected void execute(MessageTrace t) throws Exception {
        for (AbstractMessage m : t.getSequenceAsVector()) {
            if (m instanceof SynchronousReplyMessage) continue;
            AssemblyComponent senderComponent = m.getSendingExecution().getAllocationComponent().getAssemblyComponent();
            AssemblyComponent receiverComponent = m.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
            int rootOperationId = OperationRepository.ROOT_OPERATION.getId();
            Operation senderOperation = m.getSendingExecution().getOperation();
            Operation receiverOperation = m.getReceivingExecution().getOperation();
            AssemblyComponentOperationPairFactory pairFactory = this.getSystemModelRepository().getAssemblyPairFactory();
            AssemblyComponentOperationPair senderPair = senderOperation.getId() == rootOperationId ? (AssemblyComponentOperationPair)((AbstractDependencyGraph)this.getGraph()).getRootNode().getEntity() : pairFactory.getPairInstanceByPair(senderComponent, senderOperation);
            AssemblyComponentOperationPair receiverPair = receiverOperation.getId() == rootOperationId ? (AssemblyComponentOperationPair)((AbstractDependencyGraph)this.getGraph()).getRootNode().getEntity() : pairFactory.getPairInstanceByPair(receiverComponent, receiverOperation);
            DependencyGraphNode<Object> senderNode = ((AbstractDependencyGraph)this.getGraph()).getNode(senderPair.getId());
            DependencyGraphNode<Object> receiverNode = ((AbstractDependencyGraph)this.getGraph()).getNode(receiverPair.getId());
            if (senderNode == null) {
                senderNode = new DependencyGraphNode<AssemblyComponentOperationPair>(senderPair.getId(), senderPair, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getSendingExecution().isAssumed()) {
                    senderNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(senderNode.getId(), senderNode);
            } else {
                this.handleOrigin(senderNode, t.getTraceInformation());
            }
            if (receiverNode == null) {
                receiverNode = new DependencyGraphNode<AssemblyComponentOperationPair>(receiverPair.getId(), receiverPair, t.getTraceInformation(), this.getOriginRetentionPolicy());
                if (m.getReceivingExecution().isAssumed()) {
                    receiverNode.setAssumed();
                }
                ((AbstractDependencyGraph)this.getGraph()).addNode(receiverNode.getId(), receiverNode);
            } else {
                this.handleOrigin(receiverNode, t.getTraceInformation());
            }
            boolean assumed = this.isDependencyAssumed(senderNode, receiverNode);
            senderNode.addOutgoingDependency(receiverNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            receiverNode.addIncomingDependency(senderNode, assumed, t.getTraceInformation(), this.getOriginRetentionPolicy());
            this.invokeDecorators(m, senderNode, receiverNode);
        }
        this.reportSuccess(t.getTraceId());
    }

    protected void onTerminating() {
        this.getOutputPort().send((Object)((AbstractDependencyGraph)this.getGraph()));
        super.onTerminating();
    }
}

