/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.call.tree;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.plugin.trace.AbstractMessageTraceProcessingFilter;
import kieker.common.util.signature.Signature;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.Operation;
import kieker.model.system.model.SynchronousCallMessage;
import kieker.model.system.model.SynchronousReplyMessage;
import kieker.model.system.model.util.AllocationComponentOperationPair;
import kieker.model.system.model.util.AssemblyComponentOperationPair;
import kieker.tools.trace.analysis.filter.traceReconstruction.TraceProcessingException;
import kieker.tools.trace.analysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.visualization.trace.call.tree.AbstractCallTreeNode;
import kieker.visualization.trace.call.tree.WeightedDirectedCallTreeEdge;

public abstract class AbstractCallTreeFilter<T>
extends AbstractMessageTraceProcessingFilter {
    private static final String ENCODING = "UTF-8";

    public AbstractCallTreeFilter(SystemModelRepository repository) {
        super(repository);
    }

    private static final String assemblyComponentOperationPairNodeLabel(AbstractCallTreeNode<AssemblyComponentOperationPair> node, boolean shortLabels) {
        AssemblyComponentOperationPair p = node.getEntity();
        AssemblyComponent component = p.getAssemblyComponent();
        Operation operation = p.getOperation();
        String assemblyComponentName = component.getName();
        String componentTypePackagePrefx = component.getType().getPackageName();
        String componentTypeIdentifier = component.getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(assemblyComponentName).append(':');
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier).append("\\n.");
        Signature sig = operation.getSignature();
        StringBuilder opLabel = new StringBuilder(sig.getName());
        opLabel.append('(');
        String[] paramList = sig.getParamTypeList();
        if (paramList.length > 0) {
            opLabel.append("..");
        }
        opLabel.append(')');
        strBuild.append(opLabel.toString());
        return strBuild.toString();
    }

    private static final String allocationComponentOperationPairNodeLabel(AbstractCallTreeNode<AllocationComponentOperationPair> node, boolean shortLabels) {
        AllocationComponentOperationPair p = node.getEntity();
        AllocationComponent component = p.getAllocationComponent();
        Operation operation = p.getOperation();
        String resourceContainerName = component.getExecutionContainer().getName();
        String assemblyComponentName = component.getAssemblyComponent().getName();
        String componentTypePackagePrefx = component.getAssemblyComponent().getType().getPackageName();
        String componentTypeIdentifier = component.getAssemblyComponent().getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(resourceContainerName).append("::\\n").append(assemblyComponentName).append(':');
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier).append("\\n.");
        Signature sig = operation.getSignature();
        StringBuilder opLabel = new StringBuilder(sig.getName());
        opLabel.append('(');
        String[] paramList = sig.getParamTypeList();
        if (paramList.length > 0) {
            opLabel.append("..");
        }
        opLabel.append(')');
        strBuild.append(opLabel.toString());
        return strBuild.toString();
    }

    protected static final String nodeLabel(AbstractCallTreeNode<?> node, boolean shortLabels) {
        if (node.getEntity() instanceof AllocationComponentOperationPair) {
            return AbstractCallTreeFilter.allocationComponentOperationPairNodeLabel(node, shortLabels);
        }
        if (node.getEntity() instanceof AssemblyComponentOperationPair) {
            return AbstractCallTreeFilter.assemblyComponentOperationPairNodeLabel(node, shortLabels);
        }
        throw new UnsupportedOperationException("Node type not supported: " + node.getEntity().getClass().getName());
    }

    private static void dotEdgesFromSubTree(AbstractCallTreeNode<?> node, Map<AbstractCallTreeNode<?>, Integer> nodeIds, AtomicInteger nextNodeId, PrintStream ps, boolean shortLabels) {
        int newNodeId = nextNodeId.getAndIncrement();
        nodeIds.put(node, newNodeId);
        String labelText = node.isRootNode() ? "'Entry'" : AbstractCallTreeFilter.nodeLabel(node, shortLabels);
        String textLine = String.format("%d[label =\"%s\",shape=%s];", newNodeId, labelText, "none");
        ps.println(textLine);
        for (WeightedDirectedCallTreeEdge<?> child : node.getChildEdges()) {
            AbstractCallTreeNode targetNode = (AbstractCallTreeNode)child.getTarget();
            AbstractCallTreeFilter.dotEdgesFromSubTree(targetNode, nodeIds, nextNodeId, ps, shortLabels);
        }
    }

    private static void dotVerticesFromSubTree(AbstractCallTreeNode<?> n, AtomicInteger eoiCounter, Map<AbstractCallTreeNode<?>, Integer> nodeIds, PrintStream ps, boolean includeWeights) {
        int thisId = nodeIds.get(n);
        for (WeightedDirectedCallTreeEdge<?> outgoingEdge : n.getChildEdges()) {
            int childId = nodeIds.get(outgoingEdge.getTarget());
            StringBuilder strBuild = new StringBuilder(1024);
            strBuild.append('\n');
            String encodedEdge = String.format("%d->%d[style=solid,arrowhead=none", thisId, childId);
            strBuild.append(encodedEdge);
            if (includeWeights) {
                strBuild.append(",label=\"").append(outgoingEdge.getTargetWeight().get()).append('\"');
            } else if (eoiCounter != null) {
                strBuild.append(",label=\"").append(eoiCounter.getAndIncrement()).append(".\"");
            }
            strBuild.append(" ]");
            ps.println(strBuild.toString());
            AbstractCallTreeFilter.dotVerticesFromSubTree((AbstractCallTreeNode)outgoingEdge.getTarget(), eoiCounter, nodeIds, ps, includeWeights);
        }
    }

    private static void dotFromCallingTree(AbstractCallTreeNode<?> root, PrintStream ps, boolean includeWeights, boolean includeEois, boolean shortLabels) {
        ps.println("digraph G {");
        StringBuilder edgestringBuilder = new StringBuilder();
        Hashtable nodeIds = new Hashtable();
        AbstractCallTreeFilter.dotEdgesFromSubTree(root, nodeIds, new AtomicInteger(0), ps, shortLabels);
        AtomicInteger eoiCounter = includeEois ? new AtomicInteger(1) : null;
        AbstractCallTreeFilter.dotVerticesFromSubTree(root, eoiCounter, nodeIds, ps, includeWeights);
        ps.println(edgestringBuilder.toString());
        ps.println("}");
    }

    protected static void saveTreeToDotFile(AbstractCallTreeNode<?> root, String outputFn, boolean includeWeights, boolean includeEois, boolean shortLabels) throws IOException {
        try (PrintStream ps = new PrintStream(Files.newOutputStream(Paths.get(outputFn, new String[0]), new OpenOption[0]), false, ENCODING);){
            AbstractCallTreeFilter.dotFromCallingTree(root, ps, includeWeights, includeEois, shortLabels);
        }
    }

    protected static <T> void addTraceToTree(AbstractCallTreeNode<T> root, MessageTrace trace, IPairFactory<T> pairFactory, boolean aggregated) throws TraceProcessingException {
        Stack<AbstractCallTreeNode<T>> callStack = new Stack<AbstractCallTreeNode<T>>();
        callStack.push(root);
        List traceMessages = trace.getSequenceAsVector();
        String description = "PHI" + traceMessages.size();
        root.setDescription(description);
        NoOriginRetentionPolicy originPolicy = NoOriginRetentionPolicy.createInstance();
        for (AbstractMessage m : traceMessages) {
            if (m instanceof SynchronousCallMessage) {
                AbstractCallTreeNode curNode = (AbstractCallTreeNode)callStack.peek();
                T pair = pairFactory.createPair((SynchronousCallMessage)m);
                AbstractCallTreeNode<T> newNode = curNode.newCall(pair, trace, originPolicy);
                callStack.push(newNode);
                continue;
            }
            if (m instanceof SynchronousReplyMessage) {
                callStack.pop();
                continue;
            }
            throw new TraceProcessingException("Message type not supported:" + m.getClass().getName());
        }
        if (callStack.pop() != root) {
            throw new TraceProcessingException("Stack not empty after processing trace");
        }
    }

    public static <T> void writeDotForMessageTrace(AbstractCallTreeNode<T> root, IPairFactory<T> pairFactory, MessageTrace msgTrace, String outputFilename, boolean includeWeights, boolean shortLabels) throws TraceProcessingException, IOException {
        AbstractCallTreeFilter.addTraceToTree(root, msgTrace, pairFactory, false);
        AbstractCallTreeFilter.saveTreeToDotFile(root, outputFilename, includeWeights, true, shortLabels);
    }

    public static interface IPairFactory<T> {
        public T createPair(SynchronousCallMessage var1);
    }
}

