/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace.call.tree;

import java.io.File;
import java.io.IOException;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.SynchronousCallMessage;
import kieker.tools.trace.analysis.filter.traceReconstruction.TraceProcessingException;
import kieker.visualization.trace.call.tree.AbstractAggregatedCallTreeNode;
import kieker.visualization.trace.call.tree.AbstractCallTreeFilter;

public abstract class AbstractAggregatedCallTreeFilter<T>
extends AbstractCallTreeFilter<T> {
    private volatile AbstractAggregatedCallTreeNode<T> root;
    private final String dotOutputFile;
    private final boolean includeWeights;
    private final boolean shortLabels;
    private int numGraphsSaved;

    public AbstractAggregatedCallTreeFilter(SystemModelRepository repository, boolean includeWeights, boolean shortLabels, String dotOutputFile) {
        super(repository);
        this.includeWeights = includeWeights;
        this.shortLabels = shortLabels;
        this.dotOutputFile = dotOutputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRoot(AbstractAggregatedCallTreeNode<T> root) {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            this.root = root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTreeToDotFile() throws IOException {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            String outputFn = new File(this.dotOutputFile).getCanonicalPath();
            AbstractCallTreeFilter.saveTreeToDotFile(this.root, outputFn, this.includeWeights, false, this.shortLabels);
            ++this.numGraphsSaved;
            this.printDebugLogMessage(new String[]{"Wrote call tree to file '" + outputFn + "'", "Dot file can be converted using the dot tool", "Example: dot -T svg " + outputFn + " > " + outputFn + ".svg"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatusMessage() {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            super.printStatusMessage();
            this.logger.debug("Saved {} call tree{}", (Object)this.numGraphsSaved, (Object)(this.numGraphsSaved > 1 ? "s" : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTerminating() {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            try {
                this.saveTreeToDotFile();
            }
            catch (IOException ex) {
                this.logger.error("IOException while saving to dot file", (Throwable)ex);
            }
        }
        super.onTerminating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(MessageTrace trace) throws Exception {
        AbstractAggregatedCallTreeFilter abstractAggregatedCallTreeFilter = this;
        synchronized (abstractAggregatedCallTreeFilter) {
            try {
                SynchronousCallMessagePairFactory pairFactory = new SynchronousCallMessagePairFactory(this);
                AbstractCallTreeFilter.addTraceToTree(this.root, trace, pairFactory, true);
                this.reportSuccess(trace.getTraceId());
            }
            catch (TraceProcessingException ex) {
                this.logger.error("TraceProcessingException", (Throwable)((Object)ex));
                this.reportError(trace.getTraceId());
            }
        }
    }

    protected abstract T concreteCreatePair(SynchronousCallMessage var1);

    private static class SynchronousCallMessagePairFactory<T>
    implements AbstractCallTreeFilter.IPairFactory<T> {
        private final AbstractAggregatedCallTreeFilter<T> filter;

        public SynchronousCallMessagePairFactory(AbstractAggregatedCallTreeFilter<T> filter) {
            this.filter = filter;
        }

        @Override
        public T createPair(SynchronousCallMessage callMsg) {
            return this.filter.concreteCreatePair(callMsg);
        }
    }
}

