/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kieker.analysis.plugin.trace.AbstractMessageTraceProcessingFilter;
import kieker.common.util.signature.Signature;
import kieker.model.repository.AllocationRepository;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.AbstractMessage;
import kieker.model.system.model.AllocationComponent;
import kieker.model.system.model.AssemblyComponent;
import kieker.model.system.model.MessageTrace;
import kieker.model.system.model.SynchronousCallMessage;
import kieker.model.system.model.SynchronousReplyMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceDiagramFilter
extends AbstractMessageTraceProcessingFilter {
    private static final String SEQUENCE_PIC_PATH = "META-INF/sequence.pic";
    private static final String SEQUENCE_PIC_CONTENT;
    private static final String ENCODING = "UTF-8";
    private static final Logger LOGGER;
    private final String outputFnBase;
    private final boolean shortLabels;
    private final SDModes sdmode;

    public SequenceDiagramFilter(SystemModelRepository repository, SDModes sdmode, String outputFnBase, boolean shortLabels) {
        super(repository);
        this.sdmode = sdmode;
        this.outputFnBase = outputFnBase;
        this.shortLabels = shortLabels;
    }

    public void printStatusMessage() {
        super.printStatusMessage();
        int numPlots = this.getSuccessCount();
        long lastSuccessTracesId = this.getLastTraceIdSuccess();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Wrote " + numPlots + " sequence diagram" + (numPlots > 1 ? "s" : "") + " to file" + (numPlots > 1 ? "s" : "") + " with name pattern '" + this.outputFnBase + "-<traceId>.pic'");
            this.logger.debug("Pic files can be converted using the pic2plot tool (package plotutils)");
            this.logger.debug("Example: pic2plot -T svg " + this.outputFnBase + "-" + (Serializable)(numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".pic > " + this.outputFnBase + "-" + (Serializable)(numPlots > 0 ? Long.valueOf(lastSuccessTracesId) : "<traceId>") + ".svg");
        }
    }

    protected void execute(MessageTrace mt) throws Exception {
        try {
            SequenceDiagramFilter.writePicForMessageTrace(mt, this.sdmode, this.outputFnBase + "-" + mt.getTraceId() + ".pic", this.shortLabels);
            this.reportSuccess(mt.getTraceId());
        }
        catch (FileNotFoundException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("File not found", (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            this.reportError(mt.getTraceId());
            this.logger.error("Encoding not supported", (Throwable)ex);
        }
    }

    private static String assemblyComponentLabel(AssemblyComponent component, boolean shortLabels) {
        String assemblyComponentName = component.getName();
        String componentTypePackagePrefx = component.getType().getPackageName();
        String componentTypeIdentifier = component.getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(assemblyComponentName).append(':');
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier);
        return strBuild.toString();
    }

    private static String allocationComponentLabel(AllocationComponent component, boolean shortLabels) {
        String assemblyComponentName = component.getAssemblyComponent().getName();
        String componentTypePackagePrefx = component.getAssemblyComponent().getType().getPackageName();
        String componentTypeIdentifier = component.getAssemblyComponent().getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(assemblyComponentName).append(':');
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier);
        return strBuild.toString();
    }

    private static void picFromMessageTrace(MessageTrace messageTrace, SDModes sdMode, PrintStream ps, boolean shortLabels) {
        AllocationComponent receiverComponent;
        AllocationComponent senderComponent;
        List messages = messageTrace.getSequenceAsVector();
        ps.print(".PS\n");
        ps.print(SEQUENCE_PIC_CONTENT + "\n");
        ps.print("boxwid = 1.1;\n");
        ps.print("movewid = 0.5;\n");
        TreeSet<Integer> plottedComponentIds = new TreeSet<Integer>();
        AllocationComponent rootAllocationComponent = AllocationRepository.ROOT_ALLOCATION_COMPONENT;
        String rootDotId = "O" + rootAllocationComponent.getId();
        ps.print("actor(O" + rootAllocationComponent.getId() + ",\"\");\n");
        plottedComponentIds.add(rootAllocationComponent.getId());
        if (sdMode == SDModes.ALLOCATION) {
            for (AbstractMessage me : messages) {
                senderComponent = me.getSendingExecution().getAllocationComponent();
                receiverComponent = me.getReceivingExecution().getAllocationComponent();
                if (!plottedComponentIds.contains(senderComponent.getId())) {
                    ps.print("object(O" + senderComponent.getId() + ",\"" + senderComponent.getExecutionContainer().getName() + "::\",\"" + SequenceDiagramFilter.allocationComponentLabel(senderComponent, shortLabels) + "\");\n");
                    plottedComponentIds.add(senderComponent.getId());
                }
                if (plottedComponentIds.contains(receiverComponent.getId())) continue;
                ps.print("object(O" + receiverComponent.getId() + ",\"" + receiverComponent.getExecutionContainer().getName() + "::\",\"" + SequenceDiagramFilter.allocationComponentLabel(receiverComponent, shortLabels) + "\");\n");
                plottedComponentIds.add(receiverComponent.getId());
            }
        } else if (sdMode == SDModes.ASSEMBLY) {
            for (AbstractMessage me : messages) {
                senderComponent = me.getSendingExecution().getAllocationComponent().getAssemblyComponent();
                receiverComponent = me.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
                if (!plottedComponentIds.contains(senderComponent.getId())) {
                    ps.print("object(O" + senderComponent.getId() + ",\"\",\"" + SequenceDiagramFilter.assemblyComponentLabel((AssemblyComponent)senderComponent, shortLabels) + "\");\n");
                    plottedComponentIds.add(senderComponent.getId());
                }
                if (plottedComponentIds.contains(receiverComponent.getId())) continue;
                ps.print("object(O" + receiverComponent.getId() + ",\"\",\"" + SequenceDiagramFilter.assemblyComponentLabel((AssemblyComponent)receiverComponent, shortLabels) + "\");\n");
                plottedComponentIds.add(receiverComponent.getId());
            }
        } else {
            LOGGER.error("Invalid mode: {}", (Object)sdMode);
        }
        ps.print("step();\n");
        ps.print("active(" + rootDotId + ");\n");
        boolean first = true;
        for (AbstractMessage me : messages) {
            AllocationComponent receiverComponent2;
            AllocationComponent senderComponent2;
            Object senderDotId = "-1";
            Object receiverDotId = "-1";
            if (sdMode == SDModes.ALLOCATION) {
                senderComponent2 = me.getSendingExecution().getAllocationComponent();
                receiverComponent2 = me.getReceivingExecution().getAllocationComponent();
                senderDotId = "O" + senderComponent2.getId();
                receiverDotId = "O" + receiverComponent2.getId();
            } else if (sdMode == SDModes.ASSEMBLY) {
                senderComponent2 = me.getSendingExecution().getAllocationComponent().getAssemblyComponent();
                receiverComponent2 = me.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
                senderDotId = "O" + senderComponent2.getId();
                receiverDotId = "O" + receiverComponent2.getId();
            } else {
                LOGGER.error("Invalid mode: {}", (Object)sdMode);
            }
            if (me instanceof SynchronousCallMessage) {
                Signature sig = me.getReceivingExecution().getOperation().getSignature();
                StringBuilder msgLabel = new StringBuilder(sig.getName());
                msgLabel.append('(');
                String[] paramList = sig.getParamTypeList();
                if (paramList.length > 0) {
                    msgLabel.append("..");
                }
                msgLabel.append(')');
                if (first) {
                    ps.print("async();\n");
                    first = false;
                } else {
                    ps.print("sync();\n");
                }
                ps.print("message(" + (String)senderDotId + "," + (String)receiverDotId + ", \"" + msgLabel.toString() + "\");\n");
                ps.print("active(" + (String)receiverDotId + ");\n");
                ps.print("step();\n");
                continue;
            }
            if (me instanceof SynchronousReplyMessage) {
                ps.print("step();\n");
                ps.print("async();\n");
                ps.print("rmessage(" + (String)senderDotId + "," + (String)receiverDotId + ", \"\");\n");
                ps.print("inactive(" + (String)senderDotId + ");\n");
                continue;
            }
            LOGGER.error("Message type not supported: {}", (Object)me.getClass().getName());
        }
        ps.print("inactive(" + rootDotId + ");\n");
        ps.print("step();\n");
        Iterator<Object> iterator = plottedComponentIds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            ps.print("complete(O" + i + ");\n");
        }
        ps.print("complete(" + rootDotId + ");\n");
        ps.print(".PE\n");
    }

    public static void writePicForMessageTrace(MessageTrace msgTrace, SDModes sdMode, String outputFilename, boolean shortLabels) throws IOException {
        PrintStream ps = new PrintStream(Files.newOutputStream(Paths.get(outputFilename, new String[0]), new OpenOption[0]), false, ENCODING);
        SequenceDiagramFilter.picFromMessageTrace(msgTrace, sdMode, ps, shortLabels);
        ps.flush();
        ps.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LOGGER = LoggerFactory.getLogger((String)SequenceDiagramFilter.class.getCanonicalName());
        StringBuilder sb = new StringBuilder();
        boolean error = true;
        try (InputStream is = SequenceDiagramFilter.class.getClassLoader().getResourceAsStream(SEQUENCE_PIC_PATH);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, ENCODING));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            error = false;
        }
        catch (IOException exc) {
            LOGGER.error("Error while reading {}", (Object)SEQUENCE_PIC_PATH, (Object)exc);
        }
        finally {
            SEQUENCE_PIC_CONTENT = error ? "copy \"sequence.pic\";" : sb.toString();
        }
    }

    public static enum SDModes {
        ASSEMBLY,
        ALLOCATION;

    }
}

