/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.settings;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BooleanConverter;
import com.beust.jcommander.converters.FloatConverter;
import com.beust.jcommander.converters.IParameterSplitter;
import com.beust.jcommander.converters.IntegerConverter;
import com.beust.jcommander.converters.NoConverter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import kieker.common.configuration.Configuration;
import kieker.tools.settings.NoClassMapping;
import kieker.tools.settings.Setting;
import kieker.tools.settings.converters.CharConverter;
import kieker.tools.settings.converters.DoubleConverter;
import kieker.tools.settings.converters.LongConverter;
import kieker.tools.settings.converters.ShortConverter;

public class ConfigurationParser {
    private final Object settings;
    private final String prefix;

    public ConfigurationParser(String prefix, Object settings) {
        this.settings = settings;
        this.prefix = prefix == null ? "" : (prefix.isEmpty() ? "" : prefix + ".");
    }

    public void parse(Configuration configuration) throws ParameterException {
        for (Field field : this.settings.getClass().getDeclaredFields()) {
            Setting annotation = field.getAnnotation(Setting.class);
            if (annotation == null) continue;
            Object propertyPrefix = annotation.classMapping().equals(NoClassMapping.class) ? this.prefix : annotation.classMapping().getCanonicalName() + ".";
            String value = configuration.getStringProperty((String)propertyPrefix + field.getName());
            if (!"".equals(value)) {
                if (annotation.variableArity()) {
                    this.processList(field, annotation, value);
                    continue;
                }
                Object resultValue = this.processValue(field.getType(), field.getName(), annotation, value);
                this.validateValue(field.getName(), annotation.validators(), resultValue);
                this.setValue(field, resultValue);
                continue;
            }
            if (!annotation.required()) continue;
            throw new ParameterException(String.format("Parameter %s missing.", field.getName()));
        }
    }

    private void validateValue(String name, Class<? extends IValueValidator>[] validators, Object resultValue) throws ParameterException {
        for (Class<? extends IValueValidator> validatorClass : validators) {
            try {
                IValueValidator validator = validatorClass.newInstance();
                validator.validate(name, resultValue);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ParameterException(String.format("Validator %s cannot be found.", validatorClass.getCanonicalName()), (Throwable)e);
            }
        }
    }

    private void processList(Field field, Setting annotation, String value) {
        try {
            IParameterSplitter splitter = annotation.splitter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayList<Object> result = new ArrayList<Object>();
            for (String part : splitter.split(value)) {
                Object object = this.processValue(field.getType(), field.getName(), annotation, part);
                this.validateValue(field.getName(), annotation.validators(), result);
                result.add(object);
            }
            this.setValue(field, result);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ParameterException(String.format("Internal error. Cannot split '%s' with %s: %s", value, annotation.splitter().getCanonicalName(), e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private Object processValue(Class<?> clazz, String name, Setting annotation, String value) throws ParameterException {
        if (annotation.converter().equals(NoConverter.class)) {
            if (clazz.isAssignableFrom(String.class)) {
                return value;
            }
            if (clazz.isAssignableFrom(Boolean.class)) {
                return new BooleanConverter(name).convert(value);
            }
            if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Short.TYPE)) {
                return new ShortConverter(name).convert(value);
            }
            if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE)) {
                return new IntegerConverter(name).convert(value);
            }
            if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
                return new LongConverter(name).convert(value);
            }
            if (clazz.isAssignableFrom(Character.class) || clazz.isAssignableFrom(Character.TYPE)) {
                return new CharConverter(name).convert(value);
            }
            if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE)) {
                return new FloatConverter(name).convert(value);
            }
            if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
                return new DoubleConverter(name).convert(value);
            }
            return null;
        }
        try {
            IStringConverter<?> converter = annotation.converter().newInstance();
            return converter.convert(value);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ParameterException(String.format("Converter for setting %s cannot by instantiated. Value is %s", name, value), (Throwable)e);
        }
    }

    private void setValue(Field field, Object value) throws ParameterException {
        try {
            field.setAccessible(true);
            field.set(this.settings, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ParameterException(String.format("Value cannot be set to setting %s", field.getName()), (Throwable)e);
        }
    }
}

