/*
 * Decompiled with CFR 0.152.
 */
package kieker.visualization.trace;

import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.analysis.plugin.trace.AbstractMessageTraceProcessingFilter;
import kieker.model.repository.SystemModelRepository;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraphElement;
import kieker.tools.trace.analysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.trace.analysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.visualization.trace.IGraphProducingFilter;
import teetime.framework.OutputPort;

public abstract class AbstractGraphProducingFilter<G extends AbstractGraph<?, ?, ?>>
extends AbstractMessageTraceProcessingFilter
implements IGraphProducingFilter<G> {
    private static final String INCOMPATIBLE_RETENTION_ERROR_TEMPLATE = "%s: The current retention policy %s is incompatible with the requested retention policy %s.";
    private final G graph;
    private IOriginRetentionPolicy originRetentionPolicy = NoOriginRetentionPolicy.createInstance();
    private final OutputPort<G> outputPort = this.createOutputPort();

    public AbstractGraphProducingFilter(SystemModelRepository repository, G graph) {
        super(repository);
        this.graph = graph;
    }

    public OutputPort<G> getOutputPort() {
        return this.outputPort;
    }

    protected G getGraph() {
        return this.graph;
    }

    protected IOriginRetentionPolicy getOriginRetentionPolicy() {
        return this.originRetentionPolicy;
    }

    @Override
    public void requestOriginRetentionPolicy(IOriginRetentionPolicy policy) throws AnalysisConfigurationException {
        if (!this.originRetentionPolicy.isCompatibleWith(policy)) {
            throw new AnalysisConfigurationException(String.format(INCOMPATIBLE_RETENTION_ERROR_TEMPLATE, this, this.originRetentionPolicy, policy));
        }
        this.originRetentionPolicy = this.originRetentionPolicy.uniteWith(policy);
    }

    protected <T> void handleOrigin(AbstractGraphElement<T> element, T origin) {
        this.getOriginRetentionPolicy().handleOrigin(element, origin);
    }
}

