/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization.util.dot;

public final class DotFactory {
    public static final String DOT_SHAPE_BOX = "box";
    public static final String DOT_SHAPE_BOX3D = "box3d";
    public static final String DOT_SHAPE_NONE = "none";
    public static final String DOT_SHAPE_OVAL = "oval";
    public static final String DOT_STYLE_SOLID = "solid";
    public static final String DOT_STYLE_DASHED = "dashed";
    public static final String DOT_ARROWHEAD_OPEN = "open";
    public static final double DOT_DEFAULT_FONTSIZE = 0.0;
    public static final String DOT_DOT_RANKDIR_LR = "LR";
    public static final String DOT_FILLCOLOR_WHITE = "white";
    public static final String DOT_FILLCOLOR_GRAY = "gray";
    public static final String DOT_STYLE_FILLED = "filled";

    private DotFactory() {
    }

    public static StringBuilder createHeader(String name, String label, String fontcolor, String fontname, double fontsize) {
        StringBuilder dot = new StringBuilder(256);
        dot.append("digraph ").append(name).append(" {\n label=<").append(label).append(">;\n fontcolor=\"").append(fontcolor).append("\";\n fontname=\"").append(fontname).append("\";\n fontsize=\"").append(Double.toString(fontsize)).append("\";\n");
        return dot;
    }

    public static StringBuilder createNodeDefaults(String style, String shape, String framecolor, String fontcolor, String fontname, double fontsize, String imagescale) {
        StringBuilder dot = new StringBuilder(256);
        dot.append(" node [style=\"").append(style).append("\",shape=\"").append(shape).append("\",color=\"").append(framecolor).append("\",fontcolor=\"").append(fontcolor).append("\",fontname=\"").append(fontname).append("\",fontsize=\"").append(fontsize).append("\",imagescale=\"").append(imagescale).append("\"];\n");
        return dot;
    }

    public static StringBuilder createEdgeDefaults(String style, String arrowhead, String labelfontname) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(" edge [style=\"").append(style).append("\",arrowhead=\"").append(arrowhead).append("\",labelfontname=\"").append(labelfontname).append("\"];\n");
        return dot;
    }

    public static StringBuilder createNode(String prefix, String nodeId, String label, String shape, String style, String framecolor, String fillcolor, String fontcolor, double fontsize, String imageFilename, String misc, String tooltip) {
        StringBuilder dot = new StringBuilder(128);
        boolean addComma = false;
        if (prefix != null) {
            dot.append(prefix);
        }
        dot.append('\"').append(nodeId).append("\" [");
        if (label != null) {
            dot.append("label=\"").append(label).append('\"');
            addComma = true;
        }
        if (shape != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("shape=\"").append(shape).append('\"');
            addComma = true;
        }
        if (style != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("style=\"").append(style).append('\"');
            addComma = true;
        }
        if (framecolor != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("color=\"").append(framecolor).append('\"');
            addComma = true;
        }
        if (fillcolor != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("fillcolor=\"").append(fillcolor).append('\"');
            addComma = true;
        }
        if (fontcolor != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("fontcolor=\"").append(fontcolor).append('\"');
            addComma = true;
        }
        if (fontsize != 0.0) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("fontsize=\"").append(fontsize).append('\"');
            addComma = true;
        }
        if (imageFilename != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("image=\"").append(imageFilename).append('\"');
            addComma = true;
        }
        if (tooltip != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append("tooltip=\"").append(tooltip).append('\"');
            addComma = true;
        }
        if (misc != null) {
            if (addComma) {
                dot.append(',');
            }
            dot.append(misc);
        }
        dot.append("]\n");
        return dot;
    }

    public static StringBuilder createCluster(String prefix, String name, String label, String shape, String style, String framecolor, String fillcolor, String fontcolor, double fontsize, String misc) {
        StringBuilder dot = new StringBuilder(256);
        dot.append(prefix).append("subgraph \"cluster_").append(name).append("\" {\n").append(prefix).append(" label = \"").append(label);
        if (shape != null) {
            dot.append("\";\n").append(prefix).append(" shape = \"").append(shape);
        }
        if (style != null) {
            dot.append("\";\n").append(prefix).append(" style = \"").append(style);
        }
        if (framecolor != null) {
            dot.append("\";\n").append(prefix).append(" pencolor = \"").append(framecolor);
        }
        if (fillcolor != null) {
            dot.append("\";\n").append(prefix).append(" fillcolor = \"").append(fillcolor);
        }
        if (fontcolor != null) {
            dot.append("\";\n").append(prefix).append(" fontcolor = \"").append(fontcolor);
        }
        if (fontsize != 0.0) {
            dot.append("\";\n").append(prefix).append(" fontsize = \"").append(fontsize);
        }
        dot.append("\";");
        if (misc != null) {
            dot.append(misc);
        }
        dot.append('\n');
        return dot;
    }

    public static String createConnection(String prefix, String from, String to, String style, String arrowhead, String color) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(prefix).append(from).append("->").append(to);
        boolean firstFlag = true;
        if (style != null) {
            dot.append("style=\"").append(style).append('\"');
            firstFlag = false;
        }
        if (arrowhead != null) {
            if (!firstFlag) {
                dot.append(',');
            }
            dot.append(" arrowhead=\"").append(arrowhead).append('\"');
            firstFlag = false;
        }
        if (color != null) {
            if (!firstFlag) {
                dot.append(',');
            }
            dot.append(" color=\"").append(color).append('\"');
            firstFlag = false;
        }
        dot.append(']');
        return dot.toString();
    }

    public static String createConnection(String prefix, String from, String to, String label, String style, String arrowhead, String color) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(prefix).append(from).append("->").append(to).append("[label=").append(label);
        if (style != null) {
            dot.append(", style=\"").append(style).append('\"');
        }
        if (arrowhead != null) {
            dot.append(", arrowhead=\"").append(arrowhead).append('\"');
        }
        if (color != null) {
            dot.append(", color=\"").append(color).append('\"');
        }
        dot.append(']');
        return dot.toString();
    }

    public static String createConnection(String prefix, String from, String to, double taillabel, double headlabel) {
        StringBuilder dot = new StringBuilder(128);
        dot.append(prefix).append('\"').append(from).append("\" -> \"").append(to).append("\" [label=\" \",taillabel=\"").append(taillabel * 100.0).append("(\",headlabel=\"").append(headlabel * 100.0).append("\"];\n");
        return dot.toString();
    }
}

