/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.trace.analysis.filter.visualization;

import java.util.Iterator;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractGraph;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractVertex;
import kieker.tools.trace.analysis.filter.visualization.graph.AbstractVertexDecoration;
import kieker.tools.trace.analysis.filter.visualization.graph.Color;

public abstract class AbstractGraphFormatter<G extends AbstractGraph<?, ?, ?>> {
    public String createFormattedRepresentation(AbstractGraph<?, ?, ?> graph, boolean includeWeights, boolean useShortLabels, boolean plotLoops) {
        return this.formatGraph(graph, includeWeights, useShortLabels, plotLoops);
    }

    protected abstract String formatGraph(G var1, boolean var2, boolean var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFormattedDecorations(AbstractVertex<?, ?, ?> vertex) {
        AbstractVertex<?, ?, ?> abstractVertex = vertex;
        synchronized (abstractVertex) {
            StringBuilder builder = new StringBuilder();
            Iterator<AbstractVertexDecoration> decorationsIter = vertex.getDecorations().iterator();
            while (decorationsIter.hasNext()) {
                String currentDecorationText = decorationsIter.next().createFormattedOutput();
                if (currentDecorationText == null || currentDecorationText.length() == 0) continue;
                builder.append(currentDecorationText);
                if (!decorationsIter.hasNext()) continue;
                builder.append("\\n");
            }
            return builder.toString();
        }
    }

    public static void formatDecorations(StringBuilder builder, AbstractVertex<?, ?, ?> vertex) {
        String decorations = AbstractGraphFormatter.getFormattedDecorations(vertex);
        if (decorations.length() != 0) {
            builder.append("\\n");
            builder.append(decorations);
        }
    }

    public abstract String getDefaultFileName();

    public static String getDotRepresentation(Color color) {
        return String.format("#%06x", color.getRGB());
    }
}

