/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.settings.validators;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;

public class DirectoryReadValidator
implements IValueValidator<File> {
    public void validate(String name, File value) throws ParameterException {
        if (value == null) {
            throw new ParameterException(String.format("%s path not specified.", name));
        }
        try {
            if (!value.exists()) {
                throw new ParameterException(String.format("%s path %s does not exist.", name, value.getCanonicalPath()));
            }
            if (!value.isDirectory()) {
                throw new ParameterException(String.format("%s path %s is not a directory.", name, value.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            throw new ParameterException(String.format("%s path %s cannot be checked. Cause: %s", name, value, e.getLocalizedMessage()));
        }
    }
}

